/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class LevelUpEvent
extends Event {
    protected final ServerPlayer player;
    protected final PokemonLink pokemon;
    protected final ExperienceGainType cause;
    protected int beforeLevel;
    protected int afterLevel;

    protected LevelUpEvent(ServerPlayer player, PokemonLink pokemon, ExperienceGainType cause, int beforeLevel, int afterLevel) {
        this.player = player;
        this.pokemon = pokemon;
        this.cause = cause;
        this.beforeLevel = beforeLevel;
        this.afterLevel = afterLevel;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return this.player;
    }

    public PokemonLink getPokemonLink() {
        return this.pokemon;
    }

    public Pokemon getPokemon() {
        return this.pokemon.getPokemon();
    }

    public ExperienceGainType getCause() {
        return this.cause;
    }

    public int getBeforeLevel() {
        return this.beforeLevel;
    }

    public int getAfterLevel() {
        return this.afterLevel;
    }

    public int getLevelChange() {
        return this.beforeLevel - this.afterLevel;
    }

    public static class Post
    extends LevelUpEvent {
        public Post(ServerPlayer player, PokemonLink pokemon, ExperienceGainType cause, int beforeLevel, int afterLevel) {
            super(player, pokemon, cause, beforeLevel, afterLevel);
        }
    }

    @Cancelable
    public static class Pre
    extends LevelUpEvent {
        public Pre(ServerPlayer player, PokemonLink pokemon, ExperienceGainType cause, int beforeLevel, int afterLevel) {
            super(player, pokemon, cause, beforeLevel, afterLevel);
        }

        public void setAfterLevel(int afterLevel) {
            this.afterLevel = afterLevel;
        }
    }
}

