/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class EvolveEvent
extends Event {
    private final ServerPlayer player;
    private final PixelmonEntity entity;
    private final Evolution evolution;
    private final String cause;

    protected EvolveEvent(ServerPlayer player, PixelmonEntity entity, Evolution evolution, String cause) {
        this.player = player;
        this.entity = entity;
        this.evolution = evolution;
        this.cause = cause;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public PixelmonEntity getEntity() {
        return this.entity;
    }

    public Pokemon getPokemon() {
        return this.entity.getPokemon();
    }

    public Evolution getEvolution() {
        return this.evolution;
    }

    public String getCause() {
        return this.cause;
    }

    public boolean isInternal() {
        return Constants.GAME_CAUSES.contains(this.getCause());
    }

    public static final class Constants {
        public static final String BATTLE = "Battle";
        public static final String TICKING = "TICKING";
        public static final String INTERACTION = "Interaction";
        public static final String LEVELLING = "Levelling";
        public static final String MOVE_SKILL = "MoveSkill";
        public static final String COMMAND = "Command";
        public static final String TRADE = "Trade";
        public static final String TRADE_MACHINE = "TradeMachine";
        public static final String UNKNOWN = "Unknown";
        public static final Set<String> GAME_CAUSES = Sets.newHashSet((Object[])new String[]{"Battle", "TICKING", "Interaction", "Levelling", "MoveSkill", "Trade", "Command", "TradeMachine"});
    }

    public static class Post
    extends EvolveEvent {
        public Post(ServerPlayer player, PixelmonEntity entity, Evolution evolution, String cause) {
            super(player, entity, evolution, cause);
        }
    }

    @Cancelable
    public static class Pre
    extends EvolveEvent {
        public Pre(ServerPlayer player, PixelmonEntity entity, Evolution evolution, String cause) {
            super(player, entity, evolution, cause);
        }
    }
}

