/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class DropEvent
extends Event {
    public final ServerPlayer player;
    public final Mob entity;
    public final ItemDropMode dropMode;
    private final ArrayList<DroppedItem> drops;
    private int id;

    public DropEvent(ServerPlayer player, Mob entity, ItemDropMode dropMode, ArrayList<DroppedItem> items) {
        this.player = player;
        this.entity = entity;
        this.dropMode = dropMode;
        this.drops = items;
        for (DroppedItem item : items) {
            if (this.id >= item.id) continue;
            this.id = item.id;
        }
    }

    public ImmutableList<DroppedItem> getDrops() {
        return ImmutableList.builder().addAll(this.drops).build();
    }

    public void addDrop(ItemStack drop) {
        if (drop != null) {
            this.drops.add(new DroppedItem(drop, ++this.id));
        }
    }

    public void removeDrop(DroppedItem drop) {
        boolean droppingID = false;
        for (int i = 0; i < this.drops.size(); ++i) {
            if (droppingID) {
                --this.drops.get((int)i).id;
                continue;
            }
            if (this.drops.get(i) != drop) continue;
            this.drops.remove(i);
            --i;
            droppingID = true;
        }
    }

    public boolean isPokemon() {
        return this.entity instanceof PixelmonEntity;
    }

    public boolean isTrainer() {
        return this.entity instanceof NPCTrainer;
    }
}

