/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.dialogue;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.OpenDialogueInputPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class DialogueInputScreen {
    public static void openDialogueInput(ServerPlayer player, Component title, Component text) {
        Builder builder = DialogueInputScreen.builder().setTitle(title).setText(text);
        builder.sendTo(player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Component title) {
        return new Builder().setTitle(title);
    }

    public static class Builder {
        private Component title = Component.m_237113_((String)"");
        private Component text = null;
        private String defaultText = "";
        private boolean shouldCloseOnEsc = true;

        public Builder setTitle(Component title) {
            this.title = (Component)Preconditions.checkNotNull((Object)title, (Object)"title");
            return this;
        }

        public Builder setTitle(String title) {
            this.title = Component.m_237113_((String)((String)Preconditions.checkNotNull((Object)title, (Object)"title")));
            return this;
        }

        public Builder setText(Component text) {
            this.text = (Component)Preconditions.checkNotNull((Object)text, (Object)"text");
            return this;
        }

        public Builder setText(String text) {
            this.text = Component.m_237113_((String)((String)Preconditions.checkNotNull((Object)text, (Object)"text")));
            return this;
        }

        public Builder setDefaultText(String defaultText) {
            this.defaultText = (String)Preconditions.checkNotNull((Object)defaultText, (Object)"defaultText");
            return this;
        }

        public Builder setShouldCloseOnEsc(boolean b) {
            this.shouldCloseOnEsc = b;
            return this;
        }

        public void sendTo(ServerPlayer player) {
            NetworkHelper.sendPacket(player, new OpenDialogueInputPacket(this.title, this.text, this.defaultText, this.shouldCloseOnEsc));
        }
    }
}

