/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.dialogue;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.events.dialogue.DialogueChoiceEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.SetDialogueDataPacket;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class Dialogue {
    public final String name;
    private final String text;
    private final String localizedText;
    public final ArrayList<Choice> choices;
    private final boolean escapeCloses;
    public QuestProgressClient quest = null;

    @Deprecated
    public Dialogue(FriendlyByteBuf buffer) {
        this(buffer, false);
    }

    @Deprecated
    public Dialogue(FriendlyByteBuf buffer, boolean localized) {
        this.escapeCloses = buffer.readBoolean();
        String name = buffer.m_130277_();
        String string = this.name = localized ? I18n.m_118938_((String)name, (Object[])new Object[0]) : name;
        if (buffer.readBoolean() || localized) {
            this.text = null;
            this.localizedText = buffer.m_130277_();
        } else {
            this.text = buffer.m_130277_();
            this.localizedText = null;
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (byte choiceCount = buffer.readByte(); choiceCount > 0; choiceCount = (byte)(choiceCount - 1)) {
            choices.add(new Choice(buffer, localized));
        }
        this.choices = choices;
    }

    public Dialogue(FriendlyByteBuf buffer, UUID quest) {
        this.escapeCloses = buffer.readBoolean();
        if (quest == null) {
            this.name = buffer.m_130277_();
            if (buffer.readBoolean()) {
                this.localizedText = buffer.m_130277_();
                this.text = null;
            } else {
                this.localizedText = null;
                this.text = buffer.m_130277_();
            }
        } else {
            this.quest = QuestDataClient.getInstance().get(quest);
            this.name = this.quest.format(buffer.m_130277_());
            buffer.readBoolean();
            this.text = this.quest.format(buffer.m_130277_());
            this.localizedText = null;
        }
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (byte choiceCount = buffer.readByte(); choiceCount > 0; choiceCount = (byte)(choiceCount - 1)) {
            choices.add(new Choice(buffer, true));
        }
        this.choices = choices;
    }

    public Dialogue(String name, String text, String localizedText, boolean escapeCloses, ArrayList<Choice> choices) {
        this.name = name;
        this.text = text;
        this.escapeCloses = escapeCloses;
        this.localizedText = localizedText;
        this.choices = choices == null ? new ArrayList() : choices;
    }

    @Deprecated
    public void writeToBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.escapeCloses);
        buffer.m_130070_(this.name);
        buffer.writeBoolean(this.text == null);
        if (this.text == null) {
            buffer.m_130070_(this.localizedText);
        } else {
            buffer.m_130070_(this.text);
        }
        buffer.writeByte(this.choices.size());
        for (Choice choice : this.choices) {
            choice.toBytes(buffer);
        }
    }

    public String getText() {
        return this.text == null ? (I18n.m_118936_((String)this.localizedText) ? I18n.m_118938_((String)this.localizedText, (Object[])new Object[0]) : this.localizedText) : this.text;
    }

    public void open(ServerPlayer ... players) {
        this.open((UUID)null, players);
    }

    public void open(UUID quest, ServerPlayer ... players) {
        for (ServerPlayer player : players) {
            Dialogue.setPlayerDialogueData(quest, player, Lists.newArrayList((Object[])new Dialogue[]{this}), true);
        }
    }

    public boolean escapeCloses() {
        return this.escapeCloses;
    }

    public static void setPlayerDialogueData(ServerPlayer player, List<Dialogue> dialogues, boolean openGui) {
        Dialogue.setPlayerDialogueData(null, player, dialogues, openGui);
    }

    public static void setPlayerDialogueData(UUID quest, ServerPlayer player, List<Dialogue> dialogues, boolean openGui) {
        HashMap<Integer, Consumer<DialogueChoiceEvent>> choiceMap = new HashMap<Integer, Consumer<DialogueChoiceEvent>>();
        for (Dialogue dialogue : dialogues) {
            for (Choice choice : dialogue.choices) {
                choiceMap.put(choice.choiceID, choice.handle);
            }
        }
        Choice.handleMap.put(player.m_20148_(), choiceMap);
        NetworkHelper.sendPacket(player, new SetDialogueDataPacket(dialogues, openGui, quest));
    }

    public static DialogueBuilder builder() {
        return new DialogueBuilder();
    }

    public static class DialogueBuilder {
        private String name = "";
        private String text = null;
        private String localizedText = null;
        private ArrayList<Choice> choices = new ArrayList();
        private boolean escapeCloses = true;

        public Dialogue build() {
            return new Dialogue(this.name, this.text, this.localizedText, this.escapeCloses, this.choices);
        }

        public DialogueBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public DialogueBuilder setText(String text) {
            this.text = text;
            return this;
        }

        @Deprecated
        public DialogueBuilder setLocalizedText(String localizedText) {
            if (this.text != null) {
                throw new IllegalStateException("You must use setText()");
            }
            this.localizedText = localizedText;
            return this;
        }

        public DialogueBuilder addChoice(Choice choice) {
            this.choices.add(choice);
            return this;
        }

        public DialogueBuilder setChoices(ArrayList<Choice> choices) {
            this.choices = choices;
            return this;
        }

        public DialogueBuilder injectHandler(Consumer<DialogueChoiceEvent> handle) {
            ArrayList<Choice> newChoices = new ArrayList<Choice>();
            for (Choice choice : this.choices) {
                newChoices.add(Choice.builder().setText(choice.text).setHandle(handle).build(choice.choiceID));
            }
            this.setChoices(newChoices);
            return this;
        }

        public DialogueBuilder escapeCloses() {
            this.escapeCloses = true;
            return this;
        }

        public DialogueBuilder requireManualClose() {
            this.escapeCloses = false;
            return this;
        }

        public void open(ServerPlayer ... players) {
            this.build().open(players);
        }
    }
}

