/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl.requirement;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.math.BigDecimal;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class PokeDollarsRequirement
extends AbstractRequirement {
    protected double amount = 0.0;

    public PokeDollarsRequirement() {
        super("pokedollars");
    }

    @Override
    public void read(Gson gson, JsonElement json) {
        JsonObject object = json.getAsJsonObject();
        this.error = TextHelper.colour(object.get("error_message").getAsString());
        if (!object.has("value")) {
            return;
        }
        this.amount = object.get("value").getAsDouble();
    }

    @Override
    public boolean hasMetRequirement(ServerPlayer player, DayCareBox box) {
        BigDecimal balance = BankAccountProxy.getBankAccountNow(player).getBalance();
        return balance.compareTo(BigDecimal.valueOf(this.amount)) >= 0;
    }

    @Override
    public void takeFrom(ServerPlayer player, DayCareBox box) {
        BankAccount bankAccount = BankAccountProxy.getBankAccountNow(player);
        bankAccount.take(this.amount);
    }

    @Override
    public void write(CompoundTag nbt) {
        ListTag pokedollarRequirement = new ListTag();
        if (nbt.m_128441_("pokedollarRequirement")) {
            pokedollarRequirement = nbt.m_128437_("pokedollarRequirement", 6);
        }
        pokedollarRequirement.add((Object)DoubleTag.m_128500_((double)this.amount));
        nbt.m_128365_("pokedollarRequirement", (Tag)pokedollarRequirement);
    }

    @Override
    public void read(CompoundTag nbt) {
        if (!nbt.m_128441_("pokedollarRequirement")) {
            return;
        }
        ListTag pokedollarRequirement = nbt.m_128437_("pokedollarRequirement", 6);
        if (pokedollarRequirement.isEmpty()) {
            return;
        }
        DoubleTag doubleNBT = (DoubleTag)pokedollarRequirement.get(0);
        pokedollarRequirement.remove(0);
        this.amount = doubleNBT.m_7061_();
    }

    public double getAmount() {
        return this.amount;
    }
}

