/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl.requirement;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.AbstractRequirement;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.ItemStackHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ItemStackRequirement
extends AbstractRequirement {
    protected List<ItemStack> requiredItems = Lists.newArrayList();

    public ItemStackRequirement() {
        super("itemstack");
    }

    @Override
    public void read(Gson gson, JsonElement json) throws RuntimeException {
        JsonObject object = json.getAsJsonObject();
        this.error = TextHelper.colour(object.get("error_message").getAsString());
        if (!object.has("items")) {
            return;
        }
        for (JsonElement items : object.getAsJsonArray("items")) {
            JsonObject itemObject = items.getAsJsonObject();
            ItemStackHelper.parseUserInput(itemObject.get("item").getAsString(), itemObject.get("amount").getAsInt()).ifPresent(this.requiredItems::add);
        }
    }

    @Override
    public boolean hasMetRequirement(ServerPlayer player, DayCareBox box) {
        for (ItemStack requiredItem : this.requiredItems) {
            int found = 0;
            for (ItemStack item : player.m_150109_().f_35974_) {
                if (item.m_41619_() || !this.isSameItem(requiredItem, item) || (found += item.m_41613_()) < requiredItem.m_41613_()) continue;
                return true;
            }
            if (found >= requiredItem.m_41613_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void takeFrom(ServerPlayer player, DayCareBox box) {
        block0: for (ItemStack requiredItem : this.requiredItems) {
            int slotMatchingItem;
            ItemStack remove;
            for (int amount = requiredItem.m_41613_(); amount > 0 && (slotMatchingItem = this.findSlotMatchingItem(player, requiredItem)) != -1; amount -= remove.m_41613_()) {
                remove = player.m_150109_().m_8020_(slotMatchingItem);
                if (remove.m_41613_() == amount) {
                    player.m_150109_().m_6836_(slotMatchingItem, ItemStack.f_41583_);
                    continue block0;
                }
                if (remove.m_41613_() > amount) {
                    remove.m_41774_(amount);
                    continue block0;
                }
                player.m_150109_().m_6836_(slotMatchingItem, ItemStack.f_41583_);
            }
        }
        player.m_150109_().m_6596_();
    }

    private int findSlotMatchingItem(ServerPlayer player, ItemStack item) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (((ItemStack)player.m_150109_().f_35974_.get(i)).m_41619_() || !this.isSameItem(item, (ItemStack)player.m_150109_().f_35974_.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean isSameItem(ItemStack p_184431_1_, ItemStack p_184431_2_) {
        return p_184431_1_.m_41720_() == p_184431_2_.m_41720_() && ItemStack.m_150942_((ItemStack)p_184431_1_, (ItemStack)p_184431_2_);
    }

    @Override
    public void write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (ItemStack requiredItem : this.requiredItems) {
            CompoundTag itemNbt = new CompoundTag();
            itemNbt.m_128365_("item", (Tag)requiredItem.serializeNBT());
            list.add((Object)itemNbt);
        }
        ListTag itemRequirementList = new ListTag();
        if (nbt.m_128441_("itemRequirement")) {
            itemRequirementList = nbt.m_128437_("itemRequirement", 9);
        }
        itemRequirementList.add((Object)list);
        nbt.m_128365_("itemRequirement", (Tag)itemRequirementList);
    }

    @Override
    public void read(CompoundTag nbt) {
        if (!nbt.m_128441_("itemRequirement")) {
            return;
        }
        ListTag itemRequirementList = nbt.m_128437_("itemRequirement", 9);
        if (itemRequirementList.isEmpty()) {
            return;
        }
        ListTag list = itemRequirementList.m_128744_(0);
        itemRequirementList.remove(0);
        for (Tag inbt : list) {
            this.requiredItems.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt).m_128469_("item")));
        }
    }

    public List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }
}

