/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareConditionRegistry;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDuration;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDurationRegistry;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class PixelmonDayCareCondition
implements DayCareCondition {
    protected PokemonSpecification spec;
    protected List<DayCareRequirement> requirements;
    protected List<DayCareRequirement> remainingRequirements;
    protected List<DayCareDuration> durations;

    @Override
    public boolean isConditionFor(Pokemon parentOne, Pokemon parentTwo, Pokemon child) {
        return this.spec.matches(parentOne) || this.spec.matches(parentTwo);
    }

    @Override
    public List<DayCareDuration> getDurations() {
        return this.durations;
    }

    @Override
    public List<DayCareRequirement> getRequirements() {
        return this.requirements;
    }

    @Override
    public Optional<DayCareRequirement> getNextRequirement() {
        if (this.isComplete()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.remainingRequirements.get(0));
    }

    @Override
    public boolean isComplete() {
        return this.remainingRequirements.isEmpty();
    }

    @Override
    public List<DayCareRequirement> getRemainingRequirements() {
        return this.remainingRequirements;
    }

    @Override
    public boolean completeRequirement(ServerPlayer player, DayCareBox box, DayCareRequirement requirement) {
        if (requirement.hasMetRequirement(player, box)) {
            requirement.takeFrom(player, box);
            this.remainingRequirements.remove(requirement);
            return true;
        }
        return false;
    }

    @Override
    public void skipRequirement(DayCareRequirement requirement) {
        this.remainingRequirements.remove(requirement);
    }

    @Override
    public void read(Gson gson, JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        PokemonSpecification spec = PokemonSpecificationProxy.create(jsonObject.get("spec").getAsString()).get();
        ArrayList requirements = Lists.newArrayList();
        ArrayList durations = Lists.newArrayList();
        for (JsonElement element : jsonObject.getAsJsonArray("requirements")) {
            if (!element.isJsonObject()) continue;
            JsonObject requirementObject = element.getAsJsonObject();
            DayCareRequirement requirement = DayCareConditionRegistry.getRequirement(requirementObject.get("type").getAsString()).orElse(null);
            if (requirement == null) {
                Pixelmon.LOGGER.error("[BREEDING] Cannot find requirement with type: `" + requirementObject.get("type").getAsString() + "`");
                continue;
            }
            try {
                requirement.read(gson, element);
                requirements.add(requirement);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        for (JsonElement element : jsonObject.getAsJsonArray("durations")) {
            if (!element.isJsonObject()) continue;
            JsonObject durationObject = element.getAsJsonObject();
            DayCareDuration duration = DayCareDurationRegistry.getDuration(durationObject.get("type").getAsString()).orElse(null);
            if (duration == null) {
                Pixelmon.LOGGER.error("[BREEDING] Cannot find duration with type: `" + durationObject.get("type").getAsString() + "`");
                continue;
            }
            try {
                duration.read(gson, element);
                durations.add(duration);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.spec = spec;
        this.durations = durations;
        this.requirements = requirements;
        this.remainingRequirements = Lists.newArrayList(this.requirements);
    }

    @Override
    public DayCareCondition clone() {
        PixelmonDayCareCondition dayCareCondition = new PixelmonDayCareCondition();
        dayCareCondition.spec = this.spec;
        dayCareCondition.requirements = Lists.newArrayList(this.requirements);
        dayCareCondition.remainingRequirements = Lists.newArrayList(this.requirements);
        dayCareCondition.durations = Lists.newArrayList(this.durations);
        return dayCareCondition;
    }

    @Override
    public void write(CompoundTag nbt) {
        ListTag remaining = new ListTag();
        for (DayCareRequirement remainingRequirement : this.remainingRequirements) {
            CompoundTag requirementNbt = new CompoundTag();
            requirementNbt.m_128359_("key", remainingRequirement.getTypeId());
            requirementNbt.m_128359_("error", Component.Serializer.m_130703_((Component)remainingRequirement.getError()));
            remainingRequirement.write(requirementNbt);
            remaining.add((Object)requirementNbt);
        }
        nbt.m_128365_("remainingRequirements", (Tag)remaining);
    }

    @Override
    public void read(CompoundTag nbt) {
        this.remainingRequirements = Lists.newArrayList();
        for (Tag tag : nbt.m_128437_("remainingRequirements", 10)) {
            CompoundTag requirementNBT = (CompoundTag)tag;
            DayCareConditionRegistry.getRequirement(requirementNBT.m_128461_("key")).ifPresent(requirement -> {
                requirement.setError((Component)Component.Serializer.m_130701_((String)requirementNBT.m_128461_("error")));
                requirement.read(requirementNBT);
                this.remainingRequirements.add((DayCareRequirement)requirement);
            });
        }
    }
}

