/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare.event;

import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class DayCareEvent
extends Event {
    private final ServerPlayer player;
    private final PlayerPartyStorage party;

    protected DayCareEvent(ServerPlayer player, PlayerPartyStorage party) {
        this.player = player;
        this.party = party;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public PlayerPartyStorage getParty() {
        return this.party;
    }

    public PlayerDayCare getDayCare() {
        return this.party.getDayCare();
    }

    public static abstract class HourGlassUsed
    extends DayCareEvent {
        protected ItemStack item;
        protected PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> handler;

        public HourGlassUsed(ServerPlayer player, PlayerPartyStorage party, ItemStack item, PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> handler) {
            super(player, party);
            this.item = item;
            this.handler = handler;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> getHandler() {
            return this.handler;
        }

        public static class Post
        extends HourGlassUsed {
            public Post(ServerPlayer player, PlayerPartyStorage party, ItemStack item, PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> handler) {
                super(player, party, item, handler);
            }
        }

        @Cancelable
        public static class Pre
        extends HourGlassUsed {
            public Pre(ServerPlayer player, PlayerPartyStorage party, ItemStack item, PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> handler) {
                super(player, party, item, handler);
            }

            public void setItem(ItemStack item) {
                this.item = item;
            }

            public void setHandler(PropertyDispatch.TriFunction<ServerPlayer, Integer, int[], Boolean> handler) {
                this.handler = handler;
            }
        }
    }

    public static class PostDurationCalculate
    extends DayCareEvent {
        protected final DayCareBox box;
        protected final long duration;

        public PostDurationCalculate(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, long duration) {
            super(player, party);
            this.box = box;
            this.duration = duration;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    public static class PreDurationCalculate
    extends DayCareEvent {
        protected final DayCareBox box;
        protected long duration;

        public PreDurationCalculate(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, long duration) {
            super(player, party);
            this.box = box;
            this.duration = duration;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }
    }

    public static class TimerComplete
    extends DayCareEvent {
        protected final DayCareBox box;
        protected final long duration;

        public TimerComplete(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, long duration) {
            super(player, party);
            this.box = box;
            this.duration = duration;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    public static class PostTimerBegin
    extends DayCareEvent {
        protected final DayCareBox box;
        protected final long duration;

        public PostTimerBegin(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, long duration) {
            super(player, party);
            this.box = box;
            this.duration = duration;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public long getDuration() {
            return this.duration;
        }
    }

    @Cancelable
    public static class PreTimerBegin
    extends DayCareEvent {
        protected final DayCareBox box;
        protected long duration;

        public PreTimerBegin(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, long duration) {
            super(player, party);
            this.box = box;
            this.duration = duration;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }
    }

    public static class PostEggCalculate
    extends DayCareEvent {
        protected final Pokemon parentOne;
        protected final Pokemon parentTwo;
        protected final Pokemon calculatedChild;
        protected final boolean childExists;
        protected final boolean showChild;

        public PostEggCalculate(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon calculatedChild, boolean childExists, boolean showChild) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.calculatedChild = calculatedChild;
            this.childExists = childExists;
            this.showChild = showChild;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public Pokemon getCalculatedChild() {
            return this.calculatedChild;
        }

        public boolean isChildExists() {
            return this.childExists;
        }

        public boolean isShowChild() {
            return this.showChild;
        }
    }

    @Cancelable
    public static class PreEggCalculate
    extends DayCareEvent {
        protected final Pokemon parentOne;
        protected final Pokemon parentTwo;
        protected Pokemon calculatedChild;
        protected boolean childExists;
        protected boolean showChild;
        protected boolean showPotentialShiny;

        public PreEggCalculate(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon calculatedChild, boolean childExists, boolean showChild, boolean showPotentialShiny) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.calculatedChild = calculatedChild;
            this.childExists = childExists;
            this.showChild = showChild;
            this.showPotentialShiny = showPotentialShiny;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public Pokemon getCalculatedChild() {
            return this.calculatedChild;
        }

        public void setCalculatedChild(Pokemon calculatedChild) {
            this.calculatedChild = calculatedChild;
        }

        public boolean isChildExists() {
            return this.childExists;
        }

        public void setChildExists(boolean childExists) {
            this.childExists = childExists;
        }

        public boolean isShowChild() {
            return this.showChild;
        }

        public void setShowChild(boolean showChild) {
            this.showChild = showChild;
        }

        public boolean isShowPotentialShiny() {
            return this.showPotentialShiny;
        }

        public void setShowPotentialShiny(boolean showPotentialShiny) {
            this.showPotentialShiny = showPotentialShiny;
        }
    }

    public static class PostConditionStatusUpdate
    extends DayCareEvent {
        protected final DayCareBox box;
        protected final DayCareCondition condition;
        protected final DayCareRequirement requirement;
        protected final boolean canConsume;
        protected final Component errorMessage;

        public PostConditionStatusUpdate(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, DayCareCondition condition, DayCareRequirement requirement, boolean canConsume, Component errorMessage) {
            super(player, party);
            this.box = box;
            this.condition = condition;
            this.requirement = requirement;
            this.canConsume = canConsume;
            this.errorMessage = errorMessage;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public DayCareCondition getCondition() {
            return this.condition;
        }

        public DayCareRequirement getRequirement() {
            return this.requirement;
        }

        public boolean isCanConsume() {
            return this.canConsume;
        }

        public Component getErrorMessage() {
            return this.errorMessage;
        }
    }

    @Cancelable
    public static class PreConditionStatusUpdate
    extends DayCareEvent {
        protected final DayCareBox box;
        protected DayCareCondition condition;
        protected DayCareRequirement requirement;
        protected boolean canConsume;
        protected Component errorMessage;

        public PreConditionStatusUpdate(ServerPlayer player, PlayerPartyStorage party, DayCareBox box, DayCareCondition condition, DayCareRequirement requirement, boolean canConsume, Component errorMessage) {
            super(player, party);
            this.box = box;
            this.condition = condition;
            this.requirement = requirement;
            this.canConsume = canConsume;
            this.errorMessage = errorMessage;
        }

        public DayCareBox getBox() {
            return this.box;
        }

        public DayCareCondition getCondition() {
            return this.condition;
        }

        public void setCondition(DayCareCondition condition) {
            this.condition = condition;
        }

        public DayCareRequirement getRequirement() {
            return this.requirement;
        }

        public void setRequirement(DayCareRequirement requirement) {
            this.requirement = requirement;
        }

        public boolean isCanConsume() {
            return this.canConsume;
        }

        public void setCanConsume(boolean canConsume) {
            this.canConsume = canConsume;
        }

        public Component getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(Component errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class PostCollect
    extends DayCareEvent {
        protected final Pokemon parentOne;
        protected final Pokemon parentTwo;
        protected final Pokemon childGiven;
        protected final boolean addToHistory;

        public PostCollect(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon childGiven, boolean addToHistory) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.childGiven = childGiven;
            this.addToHistory = addToHistory;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public Pokemon getChildGiven() {
            return this.childGiven;
        }

        public boolean addedToHistory() {
            return this.addToHistory;
        }
    }

    @Cancelable
    public static class PreCollect
    extends DayCareEvent {
        protected Pokemon parentOne;
        protected Pokemon parentTwo;
        protected Pokemon childGiven;
        protected boolean addToHistory = true;

        public PreCollect(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon childGiven) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.childGiven = childGiven;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public void setParentOne(Pokemon parentOne) {
            this.parentOne = parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public void setParentTwo(Pokemon parentTwo) {
            this.parentTwo = parentTwo;
        }

        public Pokemon getChildGiven() {
            return this.childGiven;
        }

        public void setChildGiven(Pokemon childCreated) {
            this.childGiven = childCreated;
        }

        public boolean shouldAddToHistory() {
            return this.addToHistory;
        }

        public void setAddToHistory(boolean addToHistory) {
            this.addToHistory = addToHistory;
        }
    }

    public static class PostPokemonAdd
    extends DayCareEvent {
        protected final Pokemon parentOne;
        protected final Pokemon parentTwo;
        protected final Pokemon childCreated;

        public PostPokemonAdd(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon childCreated) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.childCreated = childCreated;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public Pokemon getChildCreated() {
            return this.childCreated;
        }
    }

    @Cancelable
    public static class PrePokemonAdd
    extends DayCareEvent {
        protected Pokemon parentOne;
        protected Pokemon parentTwo;
        protected Pokemon childCreated;

        public PrePokemonAdd(ServerPlayer player, PlayerPartyStorage party, Pokemon parentOne, Pokemon parentTwo, Pokemon childCreated) {
            super(player, party);
            this.parentOne = parentOne;
            this.parentTwo = parentTwo;
            this.childCreated = childCreated;
        }

        public Pokemon getParentOne() {
            return this.parentOne;
        }

        public void setParentOne(Pokemon parentOne) {
            this.parentOne = parentOne;
        }

        public Pokemon getParentTwo() {
            return this.parentTwo;
        }

        public void setParentTwo(Pokemon parentTwo) {
            this.parentTwo = parentTwo;
        }

        public Pokemon getChildCreated() {
            return this.childCreated;
        }

        public void setChildCreated(Pokemon childCreated) {
            this.childCreated = childCreated;
        }
    }
}

