/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.daycare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.PixelmonDayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.ItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.OneTimeFemaleItemStackRequirement;
import com.pixelmonmod.pixelmon.api.daycare.impl.requirement.PokeDollarsRequirement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DayCareConditionRegistry {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Supplier<DayCareRequirement>> REGISTERED_CONDITION_TYPES = Maps.newHashMap();
    private static final List<DayCareCondition> ALL_CONDITIONS = Lists.newCopyOnWriteArrayList();
    private static Supplier<DayCareCondition> conditionSupplier = PixelmonDayCareCondition::new;

    public static void setConditionSupplier(Supplier<DayCareCondition> conditionSupplier) {
        DayCareConditionRegistry.conditionSupplier = conditionSupplier;
    }

    public static Supplier<DayCareCondition> getConditionSupplier() {
        return conditionSupplier;
    }

    public static <T extends DayCareRequirement> void registerRequirement(Supplier<T> t) {
        REGISTERED_CONDITION_TYPES.put(((DayCareRequirement)t.get()).getTypeId().toLowerCase(Locale.ROOT), t);
    }

    public static <T extends DayCareRequirement> Optional<T> getRequirement(String id) {
        Supplier<DayCareRequirement> breedingConditionSupplier = REGISTERED_CONDITION_TYPES.get(id.toLowerCase(Locale.ROOT));
        if (breedingConditionSupplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(breedingConditionSupplier.get());
    }

    public static List<Supplier<DayCareRequirement>> getAllRequirements() {
        return Lists.newArrayList(REGISTERED_CONDITION_TYPES.values());
    }

    public static List<DayCareCondition> getAllConditions() {
        return ALL_CONDITIONS;
    }

    public static void reset() {
        ALL_CONDITIONS.clear();
    }

    public static void readFromJson(Gson gson, JsonElement jsonElement) {
        DayCareCondition dayCareCondition = conditionSupplier.get();
        if (dayCareCondition == null) {
            return;
        }
        dayCareCondition.read(gson, jsonElement);
        ALL_CONDITIONS.add(dayCareCondition);
    }

    static {
        DayCareConditionRegistry.registerRequirement(PokeDollarsRequirement::new);
        DayCareConditionRegistry.registerRequirement(ItemStackRequirement::new);
        DayCareConditionRegistry.registerRequirement(OneTimeFemaleItemStackRequirement::new);
    }
}

