/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.data;

import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.data.BlockedDataSerializer;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.MutableRibbonData;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import com.pixelmonmod.pixelmon.enums.EnumBike;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumNPCTutorType;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.properties.WoodType;

public class PixelmonDataSerializers {
    public static final EntityDataSerializer<PokemonBase> POKEMON_BASE = new BlockedDataSerializer<PokemonBase>((buffer, pokemon) -> {
        buffer.writeInt(pokemon.getSpecies().getDex());
        buffer.m_130070_(pokemon.getForm().getName());
        buffer.writeInt(pokemon.getGender().ordinal());
        buffer.m_130070_(pokemon.getPalette().getName());
        buffer.writeInt(pokemon.getEggCycles());
        buffer.writeBoolean(pokemon.getBall() != null);
        if (pokemon.getBall() != null) {
            buffer.m_130070_(pokemon.getBall().getName());
        }
    }, buffer -> {
        Species species = PixelmonSpecies.fromNationalDex(buffer.readInt());
        if (species == null) {
            buffer.m_130277_();
            buffer.readInt();
            buffer.m_130277_();
            buffer.readInt();
            if (buffer.readBoolean()) {
                buffer.m_130277_();
            }
            return null;
        }
        Stats form = species.getForm(buffer.m_130277_());
        Gender gender = Gender.getGender((short)buffer.readInt());
        PaletteProperties palette = form.getGenderProperties(gender).getPalette(buffer.m_130277_());
        int eggCycles = buffer.readInt();
        PokeBall ball = null;
        if (buffer.readBoolean()) {
            ball = PokeBallRegistry.getPokeBall(buffer.m_130277_()).orElse((Object)null);
        }
        return new PokemonBase(species, form, palette, gender, eggCycles, ball);
    }, pokemon -> new PokemonBase(pokemon.getSpecies(), pokemon.getForm(), pokemon.getPalette(), pokemon.getGender()));
    public static final EntityDataSerializer<EnumGrowth> GROWTH = new BlockedDataSerializer<EnumGrowth>((buffer, growth) -> buffer.writeInt(growth == null ? -1 : growth.ordinal()), buffer -> EnumGrowth.getGrowthFromIndex(buffer.readInt()), growth -> growth);
    public static final EntityDataSerializer<BossTier> BOSS_MODE = new BlockedDataSerializer<BossTier>((buffer, bossTier) -> buffer.m_130070_(bossTier.getID()), buffer -> BossTierRegistry.getBossTierOrNotBoss(buffer.m_130277_()), bossmode -> bossmode);
    public static final EntityDataSerializer<Ribbon> RIBBON_TYPE = new BlockedDataSerializer<Ribbon>((buffer, ribbon) -> {
        buffer.writeBoolean(ribbon == null || ribbon.getType() == null);
        if (ribbon != null && ribbon.getType() != null) {
            buffer.m_130070_(ribbon.getType().getKey());
            buffer.writeLong(ribbon.getReceivedDate());
            buffer.m_130083_(ribbon.getReceiver());
            ribbon.getRibbonData().writeToBuffer((FriendlyByteBuf)buffer);
        }
    }, buffer -> {
        if (buffer.readBoolean()) {
            return null;
        }
        return Ribbon.builder().type(buffer.m_130277_()).receivedDate(buffer.readLong()).receiver(buffer.m_130238_()).ribbonData(MutableRibbonData.fromBuffer(buffer)).build();
    }, ribbon -> ribbon);
    public static final EntityDataSerializer<SpawnLocationType> SPAWN_LOCATION_TYPE = new BlockedDataSerializer<SpawnLocationType>((buffer, spawnLocationType) -> buffer.writeInt(spawnLocationType.ordinal()), buffer -> SpawnLocationType.values()[buffer.readInt()], spawnLocationType -> spawnLocationType);
    public static final EntityDataSerializer<EnumBoundingBoxMode> BOUNDING_BOX_MODE = new BlockedDataSerializer<EnumBoundingBoxMode>((buffer, boundingBoxMode) -> buffer.writeInt(boundingBoxMode.ordinal()), buffer -> EnumBoundingBoxMode.values()[buffer.readInt()], boundingBoxMode -> boundingBoxMode);
    public static final EntityDataSerializer<EnumStatueTextureType> STATUE_TEXTURE_TYPE = new BlockedDataSerializer<EnumStatueTextureType>((buffer, statueTextureType) -> buffer.writeInt(statueTextureType.ordinal()), buffer -> EnumStatueTextureType.values()[buffer.readInt()], statueTextureType -> statueTextureType);
    public static final EntityDataSerializer<AnimationType> ANIMATION_TYPE = new BlockedDataSerializer<AnimationType>((buffer, animationType) -> buffer.writeInt(animationType.ordinal()), buffer -> AnimationType.values()[buffer.readInt()], animationType -> animationType);
    public static final EntityDataSerializer<Optional<Color>> OPTIONAL_COLOR = new BlockedDataSerializer<Optional>((buffer, color) -> {
        if (!color.isPresent()) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        buffer.writeInt(((Color)color.get()).getRed());
        buffer.writeInt(((Color)color.get()).getGreen());
        buffer.writeInt(((Color)color.get()).getBlue());
        buffer.writeInt(((Color)color.get()).getAlpha());
    }, buffer -> {
        if (!buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new Color(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));
    }, color -> color.map(value -> new Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha())));
    public static final EntityDataSerializer<Color> COLOR = new BlockedDataSerializer<Color>((buffer, color) -> buffer.writeInt(color.getRGB()), buffer -> new Color(buffer.readInt()), color -> new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
    public static final EntityDataSerializer<RaidData> RAID_DATA = new BlockedDataSerializer<RaidData>((buffer, raid) -> {
        buffer.writeInt(raid.getDen());
        buffer.writeInt(raid.getStars());
        buffer.writeInt(raid.getSpecies().getDex());
        if (raid.getForm() == null) {
            buffer.m_130070_(raid.getSpecies().getDefaultForm().getName());
        } else {
            buffer.m_130070_(raid.getForm().getName());
        }
    }, buffer -> new RaidData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130277_()), raid -> new RaidData(raid.getDen(), raid.getStars(), raid.getSpecies(), raid.getForm()));
    public static final EntityDataSerializer<EnumNPCTutorType> NPC_TUTOR_TYPE = new BlockedDataSerializer<EnumNPCTutorType>((buffer, tutorType) -> buffer.writeInt(tutorType.ordinal()), buffer -> EnumNPCTutorType.values()[buffer.readInt()], tutorType -> tutorType);
    public static final EntityDataSerializer<BaseTrainer> BASE_TRAINER = new BlockedDataSerializer<BaseTrainer>((buffer, trainer) -> buffer.writeInt(trainer.id), buffer -> {
        BaseTrainer byId = ServerNPCRegistry.trainers.getById(buffer.readInt());
        return byId;
    }, trainer -> trainer);
    public static final EntityDataSerializer<EnumTrainerAI> TRAINER_AI = new BlockedDataSerializer<EnumTrainerAI>((buffer, trainerAI) -> buffer.writeInt(trainerAI.ordinal()), buffer -> EnumTrainerAI.values()[buffer.readInt()], trainerAI -> trainerAI);
    public static final EntityDataSerializer<PokeBallMode> POKE_BALL_MODE = new BlockedDataSerializer<PokeBallMode>((buffer, pokeBallMode) -> buffer.writeInt(pokeBallMode.ordinal()), buffer -> PokeBallMode.values()[buffer.readInt()], pokeBallMode -> pokeBallMode);
    public static final EntityDataSerializer<PokeBall> POKE_BALL_TYPE = new BlockedDataSerializer<PokeBall>((buffer, pokeBall) -> buffer.m_130070_(pokeBall.getName()), buffer -> PokeBallRegistry.getPokeBall(buffer.m_130277_()).orElse((Object)null), pokeBall -> pokeBall);
    public static final EntityDataSerializer<EnumBike> BIKE_TYPE = new BlockedDataSerializer<EnumBike>((buffer, bikeType) -> buffer.writeInt(bikeType.ordinal()), buffer -> EnumBike.values()[buffer.readInt()], bikeType -> bikeType);
    public static final EntityDataSerializer<DyeColor> DYE_COLOR = new BlockedDataSerializer<DyeColor>((buffer, dyeColor) -> buffer.writeInt(dyeColor.ordinal()), buffer -> DyeColor.values()[buffer.readInt()], dyeColor -> dyeColor);
    public static final EntityDataSerializer<EnumEncounterMode> ENCOUNTER_MODE = new BlockedDataSerializer<EnumEncounterMode>((buffer, encounterMode) -> buffer.writeInt(encounterMode.ordinal()), buffer -> EnumEncounterMode.values()[buffer.readInt()], encounterMode -> encounterMode);
    public static final EntityDataSerializer<EnumMegaItemsUnlocked> MEGA_ITEM = new BlockedDataSerializer<EnumMegaItemsUnlocked>((buffer, megaItem) -> buffer.writeInt(megaItem.ordinal()), buffer -> EnumMegaItemsUnlocked.values()[buffer.readInt()], megaItem -> megaItem);
    public static final EntityDataSerializer<EnumOldGenMode> OLD_GEN_MODE = new BlockedDataSerializer<EnumOldGenMode>((buffer, oldGenMode) -> buffer.writeInt(oldGenMode.ordinal()), buffer -> EnumOldGenMode.values()[buffer.readInt()], oldGenMode -> oldGenMode);
    public static final EntityDataSerializer<BattleAIMode> BATTLE_AI_MODE = new BlockedDataSerializer<BattleAIMode>((buffer, aiMode) -> buffer.writeInt(aiMode.ordinal()), buffer -> BattleAIMode.values()[buffer.readInt()], aiMode -> aiMode);
    public static final EntityDataSerializer<WoodType> WOOD_TYPE = new BlockedDataSerializer<WoodType>((buffer, woodType) -> buffer.m_130070_(woodType.f_61839_()), buffer -> {
        String name = buffer.m_130277_();
        return WoodType.m_61843_().filter(woodType -> woodType.f_61839_().equalsIgnoreCase(name)).findFirst().get();
    }, woodType -> woodType);
    public static final EntityDataSerializer<EvolutionStage> EVO_STAGE = new BlockedDataSerializer<EvolutionStage>((buffer, evoStage) -> {
        buffer.writeBoolean(evoStage != null);
        if (evoStage != null) {
            buffer.writeByte(evoStage.ordinal());
        }
    }, buffer -> {
        if (!buffer.readBoolean()) {
            return null;
        }
        return EvolutionStage.values()[buffer.readByte()];
    }, evolutionStage -> evolutionStage);
    public static final EntityDataSerializer<String[]> STRING_ARRAY = new BlockedDataSerializer<String[]>((buffer, list) -> {
        buffer.writeInt(((String[])list).length);
        for (String s : list) {
            buffer.m_130070_(s);
        }
    }, buffer -> {
        int size = buffer.readInt();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = buffer.m_130277_();
        }
        return array;
    }, array -> array);
    public static final EntityDataSerializer<ResourceLocation> RESOURCE_LOCATION = new EntityDataSerializer<ResourceLocation>(){

        public void write(FriendlyByteBuf buffer, ResourceLocation resourceLocation) {
            buffer.writeBoolean(resourceLocation != null);
            if (resourceLocation != null) {
                buffer.m_130085_(resourceLocation);
            }
        }

        public ResourceLocation read(FriendlyByteBuf FriendlyByteBuf2) {
            if (FriendlyByteBuf2.readBoolean()) {
                return FriendlyByteBuf2.m_130281_();
            }
            return null;
        }

        public ResourceLocation copy(ResourceLocation resourceLocation) {
            if (resourceLocation != null) {
                return new ResourceLocation(resourceLocation.toString());
            }
            return null;
        }
    };
    public static final EntityDataSerializer<Pokerus> POKERUS = new EntityDataSerializer<Pokerus>(){

        public void write(FriendlyByteBuf buf, Pokerus value) {
            buf.writeShort(value.type.ordinal());
            buf.writeInt(value.secondsSinceInfection);
            buf.writeBoolean(value.announced);
        }

        public Pokerus read(FriendlyByteBuf buf) {
            Pokerus p = new Pokerus(PokerusStrain.values()[buf.readShort()]);
            p.secondsSinceInfection = buf.readInt();
            p.announced = buf.readBoolean();
            return p;
        }

        public EntityDataAccessor<Pokerus> m_135021_(int id) {
            return new EntityDataAccessor(id, (EntityDataSerializer)this);
        }

        public Pokerus copy(Pokerus value) {
            return value;
        }
    };

    public static void bootstrap() {
    }

    static {
        EntityDataSerializers.m_135050_(POKEMON_BASE);
        EntityDataSerializers.m_135050_(GROWTH);
        EntityDataSerializers.m_135050_(BOSS_MODE);
        EntityDataSerializers.m_135050_(RIBBON_TYPE);
        EntityDataSerializers.m_135050_(SPAWN_LOCATION_TYPE);
        EntityDataSerializers.m_135050_(BOUNDING_BOX_MODE);
        EntityDataSerializers.m_135050_(ANIMATION_TYPE);
        EntityDataSerializers.m_135050_(STATUE_TEXTURE_TYPE);
        EntityDataSerializers.m_135050_(OPTIONAL_COLOR);
        EntityDataSerializers.m_135050_(COLOR);
        EntityDataSerializers.m_135050_(RAID_DATA);
        EntityDataSerializers.m_135050_(NPC_TUTOR_TYPE);
        EntityDataSerializers.m_135050_(BASE_TRAINER);
        EntityDataSerializers.m_135050_(TRAINER_AI);
        EntityDataSerializers.m_135050_(POKE_BALL_MODE);
        EntityDataSerializers.m_135050_(POKE_BALL_TYPE);
        EntityDataSerializers.m_135050_(BIKE_TYPE);
        EntityDataSerializers.m_135050_(DYE_COLOR);
        EntityDataSerializers.m_135050_(ENCOUNTER_MODE);
        EntityDataSerializers.m_135050_(MEGA_ITEM);
        EntityDataSerializers.m_135050_(OLD_GEN_MODE);
        EntityDataSerializers.m_135050_(BATTLE_AI_MODE);
        EntityDataSerializers.m_135050_(WOOD_TYPE);
        EntityDataSerializers.m_135050_(RESOURCE_LOCATION);
        EntityDataSerializers.m_135050_(POKERUS);
        EntityDataSerializers.m_135050_(EVO_STAGE);
        EntityDataSerializers.m_135050_(STRING_ARRAY);
        EntityDataSerializers.m_135050_(ShaderParameters.SHADER_DATA_SERIALIZER);
        EntityDataSerializers.m_135050_(ShaderParameters.OPTIONAL_SHADER_DATA_SERIALIZER);
    }
}

