/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.data;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;

public class DataSync<A, B> {
    private final EntityDataAccessor<B> dataParameter;
    private final BiConsumer<A, B> fieldSetter;
    private final BiConsumer<Pokemon, B> fieldSetterPokemon;
    private final Class<? extends Entity> entityClass;

    public DataSync(Class<? extends Entity> entityClass, EntityDataSerializer<B> serializer, BiConsumer<A, B> fieldSetter) {
        this.dataParameter = SynchedEntityData.m_135353_(entityClass, serializer);
        this.entityClass = entityClass;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = null;
    }

    public DataSync(Class<? extends Entity> entityClass, EntityDataAccessor<B> dataParameter, BiConsumer<A, B> fieldSetter) {
        this.entityClass = entityClass;
        this.dataParameter = dataParameter;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = null;
    }

    public DataSync(Class<? extends Entity> entityClass, EntityDataSerializer<B> serializer, BiConsumer<A, B> fieldSetter, BiConsumer<Pokemon, B> fieldSetterPokemon) {
        this.entityClass = entityClass;
        this.dataParameter = SynchedEntityData.m_135353_(entityClass, serializer);
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = fieldSetterPokemon;
    }

    public DataSync(Class<? extends Entity> entityClass, EntityDataAccessor<B> dataParameter, BiConsumer<A, B> fieldSetter, BiConsumer<Pokemon, B> fieldSetterPokemon) {
        this.entityClass = entityClass;
        this.dataParameter = dataParameter;
        this.fieldSetter = fieldSetter;
        this.fieldSetterPokemon = fieldSetterPokemon;
    }

    public int getParameterId() {
        return this.dataParameter.m_135015_();
    }

    public EntityDataAccessor<B> getEntityDataAccessor() {
        return this.dataParameter;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key, Entity sender) {
        if (!Objects.equals(key, this.dataParameter)) {
            return;
        }
        this.fieldSetter.accept(sender, sender.m_20088_().m_135370_(key));
    }

    public void set(Entity sender, Object data) {
        if (this.entityClass.isAssignableFrom(sender.getClass())) {
            this.fieldSetter.accept(sender, data);
        }
        sender.m_20088_().m_135381_(this.dataParameter, data);
    }

    public void set(Pokemon sender, Object data) {
        Optional<PixelmonEntity> pixelmonEntity = sender.getPixelmonEntity();
        if (pixelmonEntity.isPresent()) {
            this.set((Entity)pixelmonEntity.get(), data);
        } else {
            this.fieldSetterPokemon.accept(sender, data);
        }
    }

    static {
        CommonHelper.disableLogMessage(SynchedEntityData.class, ".*defineId called for:.*");
    }
}

