/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.events.storage.BoxCountCalculateEvent;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import java.util.UUID;
import net.minecraftforge.eventbus.api.Event;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/storage.yml")
public class StorageConfig
extends AbstractYamlConfig {
    @Comment(value="The number of boxes a player has access to in the PC\n")
    private int computerBoxes = 30;
    @Comment(value="Whether or not Pixelmon entities (such as naturally spawning Pok\u00e9mon and NPC Trainers) are saved with the world. If enabled, the size of the world save file and the time needed to save the world increase.\n")
    private boolean writeEntitiesToWorld = false;
    @Comment(value="Whether or not data about players' Pok\u00e9mon is saved when the world is saved. If this option is disabled, player Pok\u00e9mon will need to be saved manually.\n")
    private boolean dataSaveOnWorldSave = true;
    @Comment(value="Activates off-main thread saving of party and computer data\n")
    private boolean useAsyncSaving = true;
    @Comment(value="The interval in seconds that the async saver will save all queued data to disk.\n")
    private int asyncInterval = 60;

    public int getComputerBoxes(UUID uuid) {
        BoxCountCalculateEvent.Pre pre = new BoxCountCalculateEvent.Pre(uuid, this.computerBoxes);
        Pixelmon.EVENT_BUS.post((Event)pre);
        Pixelmon.EVENT_BUS.post((Event)new BoxCountCalculateEvent.Post(uuid, pre.getBoxCount()));
        return pre.getBoxCount();
    }

    public boolean isWriteEntitiesToWorld() {
        return this.writeEntitiesToWorld;
    }

    public boolean isDataSaveOnWorldSave() {
        return this.dataSaveOnWorldSave;
    }

    public boolean isUseAsyncSaving() {
        return this.useAsyncSaving;
    }

    public int getAsyncInterval() {
        return this.asyncInterval;
    }
}

