/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.config.EnumPokelootModes;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PokeLootRate;
import com.pixelmonmod.pixelmon.api.config.adapter.PokeLootRateAdapter;
import com.pixelmonmod.pixelmon.api.config.adapter.PokemonSpecificationAdapter;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.data.Serializers;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.world.dimension.ultraspace.UltraSpace;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/spawning.yml")
@Serializers(value={PokeLootRateAdapter.class, PokemonSpecificationAdapter.class})
public class SpawningConfig
extends AbstractYamlConfig {
    private static final Map<String, Long> INTERVAL_TIMES = new HashMap<String, Long>();
    @Comment(value="The minimum number of blocks away from the nearest player a Pok\u00e9mon can be when despawned.\n")
    private int despawnRadius = 80;
    @Comment(value="Modifies the rarity of shiny Pok\u00e9mon.\n")
    private float shinyRate = 4096.0f;
    @Comment(value="Modifies the rarity of shiny Pok\u00e9mon in the Ultra Space Dimension (shinyRate * ultraSpaceShinyModifier).\n")
    private float ultraSpaceShinyRateMultiplier = 0.5f;
    @Comment(value="The amount the shiny charm will multiply the shiny chance\n")
    private float shinyCharmRateMultiplier = 3.0f;
    @Comment(value="Modifies the rarity of Pok\u00e9mon with hidden abilities.\n")
    private float hiddenAbilityRate = 150.0f;
    @Comment(value="Modifies the rarity of hidden abilities in the Ultra Space Dimension (hiddenAbilitySpawnRate * ultraSpaceHiddenAbilityModifier).\n")
    private float ultraSpaceHiddenAbilityMultiplier = 0.5f;
    @Comment(value="Modifies the rarity of horde battles in the Ultra Space.\n")
    private float ultraSpaceHordeSpawnRate = 0.4f;
    @Comment(value="How often (in ticks) on average a Legendary Pok\u00e9mon attempts to spawn. The actual time interval ranges from 60% to 140% of the specified value in this setting. The chance of the spawn attempt succeeding is defined by the legendarySpawnChance setting.\n")
    private int legendarySpawnTicks = 25000;
    @Comment(value="The chance of a Legendary Pok\u00e9mon spawn attempt succeeding (0-1) if a viable location has been found for one to spawn. The frequency of this spawn attempt is defined by the legendarySpawnTicks setting.\n")
    private float legendarySpawnChance = 0.3f;
    @Comment(value="A multiplier that speeds up legendary and mega boss spawning based on player count. ticks = spawnTicks / (1 + (number of players - 1) * spawnTicksPlayerMultiplier)\n")
    private float spawnTicksPlayerMultiplier = 0.01f;
    @Comment(value="If enabled, wild Pok\u00e9mon and trainers will spawn closer to the level range of the player.\nFor example, a party where the highest level is 5 will never see Pok\u00e9mon or trainers above level 15 unless through fishing.\n If the player has a Pok\u00e9mon above level 39, only trainers are affected.\n")
    private boolean spawnLevelsCloserToPlayerLevels = true;
    @Comment(value="If enabled, the y-value of the position a Pok\u00e9mon spawns at will effect the Pok\u00e9mon level proportionately, such that lower y-values will have higher level Pok\u00e9mon.\n")
    private boolean spawnLevelsIncreaseInCaves = true;
    @Comment(value="If enabled, the Ultra Space Pokemon will be set at a higher level than the maximum level in your party MaxPartyLevel * ultra-space-level-multiplier\n")
    private boolean spawnLevelsIncreaseInUltraSpace = true;
    @Comment(value="The max level multiplier when you're at a lower level in caves\n")
    private int caveMaxMultiplier = 4;
    @Comment(value="The maximum level multiplier when you're in Ultra Space.\n")
    private double ultraSpaceLevelMultiplier = 2.0;
    @Comment(value="Chance for a wild Pokemon to turn into a Ditto on capture.\n")
    private double transformToDittoOnCatch = 0.001;
    @Comment(value="Percentage chance for a Meltan to transform into Ditto on capture. 1 = 100%\n")
    private double meltanTransformChance = 0.75;
    @Comment(value="Chance for a Meltan to spawn with each opening. 1/X\n")
    private int meltanBoxSpawnRate = 300;
    @Comment(value="Maximum block distance away from the box that a Meltan could spawn.\n")
    private int meltanBoxSpawnRadius = 15;
    @Comment(value="Amount of Netherite Scraps to initially open the Mystery Box.\n")
    private int meltanBoxInitialScrapsCount = 4;
    @Comment(value="Multiplier for the amount of scraps needed per box opening after the first.\n")
    private double meltanBoxScrapsMultiplier = 1.8;
    @Comment(value="Amount of time, in milliseconds, that it takes for the Mystery Box to open.\n")
    private long meltanBoxOpenDurationMillis = 100000L;
    @Comment(value="Amount of time, in milliseconds, that it takes before the Mystery Box can be opened again.\n")
    private long meltanBoxCooldownDurationMillis = 3000000L;
    @Comment(value="Pokemon which can transform to Ditto upon capture\n")
    private List<String> canTransformToDittoOnCatch = Lists.newArrayList((Object[])new String[]{"Pidgey", "Rattata", "Gastly", "Zubat", "Mankey", "Yanma", "Hoothoot", "Sentret", "Zigzagoon", "Gulpin", "Whismur", "Taillow", "Remoraid", "Starly"});
    @Comment(value="Chance of a wild Pok\u00e9mon spawning with the Gigantamax Factor (1/rate). 0 disables Gigantamax Factor spawns.\n")
    private float gigantamaxFactorRate = 512.0f;
    @Comment(value="Modifies the rarity of the Gigantamax Factor in the Ultra Space Dimension (gigantamaxFactorSpawnRate * ultraSpaceGigantamaxFactorModifier).\n -1 disables Gigantamax Factor spawns in Ultra Space.\n")
    private float ultraSpaceGigantamaxFactorModifier = -1.0f;
    @Comment(value="Whether or not Legendary Pok\u00e9mon will spawn naturally. This only affects Pok\u00e9mon that use the Legendary spawn rate.\n")
    private boolean allowLegendarySpawn = true;
    @Comment(value="Number of ticks until legendaries will despawn.\n")
    private int legendaryDespawnTicks = 6000;
    @Comment(value="Whether or not a message will display when a Legendary Pok\u00e9mon spawns.\nThe message also displays which biome the Pok\u00e9mon spawned in.\n")
    private boolean displayLegendaryGlobalMessage = true;
    @Comment(value="Displays server-wide announcement 'A Legendary has spawned in a Max Raid Den in a <name> biome' when a Legendary spawns in one.\n")
    private boolean doLegendaryRaidEvent = true;
    @Comment(value="If set to true, Pok\u00e9mon will spawn with the most recent moves in their level-up movepools. If false, Pok\u00e9mon will spawn with random moves from their level-up movepools.\n")
    private boolean useRecentLevelMoves = false;
    @Comment(value="Whether or not wild Pok\u00e9mon will despawn if the player flees from them or loses against them.\n")
    private boolean despawnOnFleeOrLoss = false;
    @Comment(value="Chance that a bell, at dawn, will start to ring. 1 = 100%.\n")
    private double bellSuccessChance = 0.01;
    @Comment(value="Range in blocks that Clear/Tidal Bells will seek out other bells.\n")
    private int bellInclusionRange = 10;
    @Comment(value="How long the effects of the Black/White Flute last for in seconds once used.\n")
    private int lureFluteDuration = 180;
    @Comment(value="By how many levels the Black/White Flute can affect spawns by.\n")
    private int lureFluteLevelModifier = 10;
    @Comment(value="Whether or not Pok\u00e9mon from a specific generation can spawn. All generations enabled by default.\n")
    private List<Integer> blockedGenerations = Lists.newArrayList();
    @Comment(value="Allow Zygarde Cells to spawn randomly in the world.\n")
    private boolean spawnZygardeCells = true;
    @Comment(value="The rate at which the player tracking spawner will refresh the spawns around the player.\n\nIf you're on a server you want this number to be higher. This will mean less spawns per player but is important\nas it will impact your server's performance if too low.\n\nFor single player the performance is irrelevant as you're just the one player.\n")
    private int playerTrackingSpawnerSpawnCollectionRate = 2;
    private LevelDistance levelDistance = new LevelDistance();
    private WildSpawning wildSpawning = new WildSpawning();
    private BossSpawning bossSpawning = new BossSpawning();
    private PokeLoot pokeLoot = new PokeLoot();
    private PokeStop pokeStop = new PokeStop();
    private Map<String, PokemonSpecification> autoTagSpecs = new HashMap<String, PokemonSpecification>(){
        {
            this.put("shiny", PokemonSpecificationProxy.create("shiny").get());
            this.put("gen1", PokemonSpecificationProxy.create("generation:1").get());
            this.put("gen2", PokemonSpecificationProxy.create("generation:2").get());
            this.put("gen3", PokemonSpecificationProxy.create("generation:3").get());
            this.put("gen4", PokemonSpecificationProxy.create("generation:4").get());
            this.put("gen5", PokemonSpecificationProxy.create("generation:5").get());
            this.put("gen6", PokemonSpecificationProxy.create("generation:6").get());
            this.put("gen7", PokemonSpecificationProxy.create("generation:7").get());
            this.put("gen8", PokemonSpecificationProxy.create("generation:8").get());
            this.put("legendary", PokemonSpecificationProxy.create("islegendary:true").get());
            this.put("nonlegendary", PokemonSpecificationProxy.create("islegendary:false").get());
        }
    };
    private Map<String, Integer> intervalSeconds = Map.of("wormhole_ultra_space", 400, "wormhole_overworld", 1200);
    @Comment(value="Indicates which dimensions that all Pokemon will be aggressive.\n")
    private List<String> alwaysAggressiveDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space"});
    @Comment(value="Indicates which dimensions a Horde Battle may occur in.\n")
    private List<String> hordeBattleDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space"});
    @Comment(value="Indicates which dimensions that Pokemon spawning are disabled in.\n")
    private List<String> spawningDisabledDimensions = Lists.newArrayList();

    public int getDespawnRadius() {
        return this.despawnRadius;
    }

    public float getShinyRate() {
        return this.getShinyRate(null);
    }

    public float getShinyCharmMultiplier() {
        return this.shinyCharmRateMultiplier;
    }

    public float getShinyRate(ResourceKey<Level> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            return this.shinyRate * this.ultraSpaceShinyRateMultiplier;
        }
        return this.shinyRate;
    }

    public int getLegendarySpawnTicks() {
        return this.legendarySpawnTicks;
    }

    public float getLegendarySpawnChance() {
        return this.legendarySpawnChance;
    }

    public float getSpawnTicksPlayerMultiplier() {
        return this.spawnTicksPlayerMultiplier;
    }

    public boolean isSpawnLevelsCloserToPlayerLevels() {
        return this.spawnLevelsCloserToPlayerLevels;
    }

    public boolean isSpawnLevelsIncreaseInCaves() {
        return this.spawnLevelsIncreaseInCaves;
    }

    public boolean checkInterval(String interval) {
        if (interval == null) {
            return true;
        }
        if (!this.intervalSeconds.containsKey(interval)) {
            return true;
        }
        if (this.intervalSeconds.get(interval) == -1) {
            return false;
        }
        Long last = INTERVAL_TIMES.get(interval);
        if (last == null || !this.intervalSeconds.containsKey(interval)) {
            return true;
        }
        return last < System.currentTimeMillis();
    }

    public void consumeInterval(String interval) {
        if (this.intervalSeconds.containsKey(interval)) {
            INTERVAL_TIMES.put(interval, System.currentTimeMillis() + (long)(this.intervalSeconds.get(interval) * 1000));
        }
    }

    public int getCaveMaxMultiplier() {
        return this.caveMaxMultiplier;
    }

    public double getUltraSpaceLevelMultiplier() {
        return this.ultraSpaceLevelMultiplier;
    }

    public double getTransformToDittoOnCatch() {
        return this.transformToDittoOnCatch;
    }

    public double getMeltanTransformChance() {
        return this.meltanTransformChance;
    }

    public int getMeltanBoxSpawnRate() {
        return this.meltanBoxSpawnRate;
    }

    public int getMeltanBoxSpawnRadius() {
        return this.meltanBoxSpawnRadius;
    }

    public int getMeltanBoxInitialScrapsCount() {
        return this.meltanBoxInitialScrapsCount;
    }

    public double getMeltanBoxScrapsMultiplier() {
        return this.meltanBoxScrapsMultiplier;
    }

    public long getMeltanBoxOpenDurationMillis() {
        return this.meltanBoxOpenDurationMillis;
    }

    public long getMeltanBoxCooldownDurationMillis() {
        return this.meltanBoxCooldownDurationMillis;
    }

    public List<String> getCanTransformToDittoOnCatch() {
        return this.canTransformToDittoOnCatch;
    }

    @Deprecated
    public float getHiddenAbilityRate() {
        return this.getHiddenAbilityRate(null);
    }

    @Deprecated
    public float getHiddenAbilityRate(ResourceKey<Level> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            return this.hiddenAbilityRate * this.ultraSpaceHiddenAbilityMultiplier;
        }
        return this.hiddenAbilityRate;
    }

    public boolean shouldHaveHiddenAbility(Stats form, @Nullable ResourceKey<Level> dimension) {
        if (!form.getAbilities().hasHiddenAbilities()) {
            return false;
        }
        if (dimension == null || !Objects.equals(dimension, UltraSpace.WORLD)) {
            return this.shouldHaveHiddenAbility(this.hiddenAbilityRate);
        }
        return this.shouldHaveHiddenAbility(this.hiddenAbilityRate * this.ultraSpaceHiddenAbilityMultiplier);
    }

    public boolean shouldHaveHiddenAbility(float rate) {
        return RandomHelper.getRandomChance(1.0f / rate);
    }

    public float getGigantamaxFactorRate() {
        return this.gigantamaxFactorRate;
    }

    public float getGigantamaxFactorRate(ResourceKey<Level> dimension) {
        if (dimension != null && dimension == UltraSpace.WORLD) {
            if (this.ultraSpaceGigantamaxFactorModifier == -1.0f) {
                return -1.0f;
            }
            return this.ultraSpaceGigantamaxFactorModifier * this.gigantamaxFactorRate;
        }
        return this.gigantamaxFactorRate;
    }

    public boolean isAllowLegendarySpawn() {
        return this.allowLegendarySpawn;
    }

    public int getLegendaryDespawnTicks() {
        return this.legendaryDespawnTicks;
    }

    public boolean isDisplayLegendaryGlobalMessage() {
        return this.displayLegendaryGlobalMessage;
    }

    public boolean isDoLegendaryRaidEvent() {
        return this.doLegendaryRaidEvent;
    }

    public boolean isUseRecentLevelMoves() {
        return this.useRecentLevelMoves;
    }

    public boolean isDespawnOnFleeOrLoss() {
        return this.despawnOnFleeOrLoss;
    }

    public double getBellSuccessChance() {
        return this.bellSuccessChance;
    }

    public int getBellInclusionRange() {
        return this.bellInclusionRange;
    }

    public int getLureFluteDuration() {
        return this.lureFluteDuration;
    }

    public int getLureFluteLevelModifier() {
        return this.lureFluteLevelModifier;
    }

    public List<Integer> getBlockedGenerations() {
        return this.blockedGenerations;
    }

    public boolean isGenerationEnabled(int generation) {
        return !this.blockedGenerations.contains(generation);
    }

    public boolean allGenerationsDisabled() {
        return this.blockedGenerations.size() == 8;
    }

    public boolean allGenerationsEnabled() {
        return this.blockedGenerations.isEmpty();
    }

    public int getRandomEnabledGeneration() {
        if (PixelmonConfigProxy.getSpawning().allGenerationsEnabled()) {
            return RandomHelper.getRandomNumberBetween(1, 8);
        }
        if (PixelmonConfigProxy.getSpawning().allGenerationsDisabled()) {
            throw new IllegalStateException();
        }
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (int i = 1; i < 9; ++i) {
            if (!this.isGenerationEnabled(i)) continue;
            generations.add(i);
        }
        return (Integer)generations.get(RandomHelper.getRandomNumberBetween(0, generations.size() - 1));
    }

    public boolean isSpawnZygardeCells() {
        return this.spawnZygardeCells;
    }

    public LevelDistance getLevelDistance() {
        return this.levelDistance;
    }

    public WildSpawning getWildSpawning() {
        return this.wildSpawning;
    }

    public BossSpawning getBossSpawning() {
        return this.bossSpawning;
    }

    public PokeLoot getPokeLoot() {
        return this.pokeLoot;
    }

    public PokeStop getPokeStop() {
        return this.pokeStop;
    }

    public boolean isSpawnLevelsIncreaseInUltraSpace() {
        return this.spawnLevelsIncreaseInUltraSpace;
    }

    public float getUltraSpaceHordeSpawnRate() {
        return this.ultraSpaceHordeSpawnRate;
    }

    public boolean isAlwaysAggressiveDimensions(Level world) {
        return this.alwaysAggressiveDimensions.contains(world.m_46472_().m_135782_().toString());
    }

    public boolean isHordeBattleDimensions(Level world) {
        return this.hordeBattleDimensions.contains(world.m_46472_().m_135782_().toString());
    }

    public boolean isSpawningDisabledDimension(Level world) {
        return this.spawningDisabledDimensions.contains(world.m_46472_().m_135782_().toString());
    }

    public int getPlayerTrackingSpawnerSpawnCollectionRate() {
        return this.playerTrackingSpawnerSpawnCollectionRate;
    }

    public Map<String, PokemonSpecification> getAutoTagSpecs() {
        return this.autoTagSpecs;
    }

    public void removeIntervalTime(String tag) {
        INTERVAL_TIMES.remove(tag);
    }

    @ConfigSerializable
    public static class LevelDistance {
        @Comment(value="If enabled, wild Pok\u00e9mon levels will increase as the distance from the world spawn point increases.\nIf disabled, wild Pok\u00e9mon will spawn with varying levels regardless of the distance from the world spawn point.\n")
        private boolean spawnLevelsByDistance = false;
        @Comment(value="The maximum level that Pok\u00e9mon can spawn at when the spawnLevelsByDistance option is enabled.\n")
        private int maxLevelByDistance = 60;
        @Comment(value="If the spawnLevelsByDistance setting is enabled, this setting determines the rate (in block distance)\nthat wild Pok\u00e9mon levels increase according to the distance from the world spawn point.\n")
        private int distancePerLevel = 30;

        public boolean isSpawnLevelsByDistance() {
            return this.spawnLevelsByDistance;
        }

        public int getMaxLevelByDistance() {
            return this.maxLevelByDistance;
        }

        public int getDistancePerLevel() {
            return this.distancePerLevel;
        }
    }

    @ConfigSerializable
    public static class WildSpawning {
        @Comment(value="The maximum number of entities (NPC or Pok\u00e9mon) that can spawn per player. Lower for better performance.\n")
        private int entitiesPerPlayer = 60;
        @Comment(value="The maximum number of spawns in a single spawn cycle for a single player.\nLower for slower spawning and better performance.\nValues above 5 are very unlikely to make a noticeable difference.\n")
        private int spawnsPerPass = 5;
        @Comment(value="The number of spawn passes made per minute. Decrease for better performance.\n")
        private float spawnFrequency = 80.0f;
        @Comment(value="The minimum number of blocks between a spawned entity and an existing living entity.\n")
        private float minimumDistanceBetweenSpawns = 2.0f;
        @Comment(value="The minimum distance from the player that entities may spawn. The lower this is, the closer entities will spawn to players.\n")
        private int minimumDistanceFromCentre = 5;
        @Comment(value="The maximum distance from the player that entities may spawn.\n")
        private int maximumDistanceFromCentre = 60;
        @Comment(value="How many ticks 'lead' the player tracking spawner will give players based on their motion. This tries to spawn at locations the player is about to be.\n")
        private float horizontalTrackFactor = 80.0f;
        @Comment(value="How many ticks 'lead' the player tracking spawner will give players based on their vertical motion. Typically best as zero due to the interference jumping can cause.\n")
        private float verticalTrackFactor = 0.0f;
        @Comment(value="The horizontal radius of the areas randomly selected near the player to do spawning in. Lower for better performance but less reliable spawning.\n")
        private int horizontalSliceRadius = 10;
        @Comment(value="The vertical radius of the areas randomly selected near the player to do spawning in.\n Lower for better performance but less reliable spawning. Making this larger than the horizontal slice radius is a good idea.\n")
        private int verticalSliceRadius = 25;
        @Comment(value="The maximum number of Pok\u00e9mon that can be naturally spawned in at once. This does not count fishing, Move Skills, commands, or legendary spawning\n")
        private int maximumSpawnedPokemon = 3000;
        @Comment(value="The maximum number of Flying Pok\u00e9mon that can be naturally spawned in at once (soft limit). This does not count fishing, external moves, commands, or legendary spawning.\n")
        private int maximumSpawnedFlyingPokemon = 500;
        @Comment(value="The maximum number of Flying Pok\u00e9mon that can spawn per player. Lower for better performance.\n")
        private int maximumSpawnedFlyingPokemonPerPlayer = 45;

        public int getEntitiesPerPlayer() {
            return this.entitiesPerPlayer;
        }

        public int getSpawnsPerPass() {
            return this.spawnsPerPass;
        }

        public float getSpawnFrequency() {
            return this.spawnFrequency;
        }

        public float getMinimumDistanceBetweenSpawns() {
            return this.minimumDistanceBetweenSpawns;
        }

        public int getMinimumDistanceFromCentre() {
            return this.minimumDistanceFromCentre;
        }

        public int getMaximumDistanceFromCentre() {
            return this.maximumDistanceFromCentre;
        }

        public float getHorizontalTrackFactor() {
            return this.horizontalTrackFactor;
        }

        public float getVerticalTrackFactor() {
            return this.verticalTrackFactor;
        }

        public int getHorizontalSliceRadius() {
            return this.horizontalSliceRadius;
        }

        public int getVerticalSliceRadius() {
            return this.verticalSliceRadius;
        }

        public int getMaximumSpawnedPokemon() {
            return this.maximumSpawnedPokemon;
        }

        public int getMaximumSpawnedFlyingPokemon() {
            return this.maximumSpawnedFlyingPokemon;
        }

        public int getMaximumSpawnedFlyingPokemonPerPlayer() {
            return this.maximumSpawnedFlyingPokemonPerPlayer;
        }
    }

    @ConfigSerializable
    public static class BossSpawning {
        @Comment(value="The rate of boss Pok\u00e9mon in the wild (1/x) not including mega bosses.\n")
        private float bossRate = 256.0f;
        @Comment(value="Modifies the rarity of bosses in the Ultra Space Dimension (bossRate * ultraSpaceBossModifier).\n")
        private float ultraSpaceBossModifier = 0.5f;
        @Comment(value="Whether bosses that spawn must Mega Evolve if they can.\n")
        private boolean bossesAlwaysMegaIfPossible = true;
        @Comment(value="How often (on average) a boss Pok\u00e9mon will attempt to spawn.\n")
        private int bossSpawnTicks = 10000;
        @Comment(value="Chance that a Mega Boss spawn attempt will succeed. 1 = 100%\n")
        private float bossSpawnChance = 0.3f;

        public float getBossRate() {
            return this.bossRate;
        }

        public float getBossRate(ResourceKey<Level> dimension) {
            if (dimension != null && dimension == UltraSpace.WORLD) {
                return this.bossRate * this.ultraSpaceBossModifier;
            }
            return this.bossRate;
        }

        public boolean isBossesAlwaysMegaIfPossible() {
            return this.bossesAlwaysMegaIfPossible;
        }

        public int getBossSpawnTicks() {
            return this.bossSpawnTicks;
        }

        public float getBossSpawnChance() {
            return this.bossSpawnChance;
        }
    }

    @ConfigSerializable
    public static class PokeLoot {
        @Comment(value="Whether or not visible Pok\u00e9Loot chests spawn naturally.\n")
        private boolean spawnNormal = true;
        @Comment(value="Whether or not invisible Pok\u00e9Loot chests spawn naturally.\n")
        private boolean spawnHidden = true;
        @Comment(value="Whether or not Hidden Grottos spawn naturally.\n")
        private boolean spawnGrotto = true;
        @Comment(value="The frequency at which Pok\u00e9Loot chests spawn. The Different Modes are as Follows:\n    - MINIMAL\n    - NORMAL\n    - MORE\n    - EXTREME\n")
        private PokeLootRate spawnRate = PokeLootRate.NORMAL;
        @Comment(value="The default setting for how Pok\u00e9Loot chests act once looted. The Different Modes are as Follows:\n    - FCFS\n    - PL\n    - PU\n    - TIMED\n")
        private EnumPokelootModes spawnMode = EnumPokelootModes.FCFS;
        @Comment(value="How often players can loot Pok\u00e9Loot chests that are set to have timed loot. This value is in hours.\n")
        private int lootTime = 24;

        public boolean isSpawnNormal() {
            return this.spawnNormal;
        }

        public boolean isSpawnHidden() {
            return this.spawnHidden;
        }

        public boolean isSpawnGrotto() {
            return this.spawnGrotto;
        }

        public PokeLootRate getSpawnRate() {
            return this.spawnRate;
        }

        public EnumPokelootModes getSpawnMode() {
            return this.spawnMode;
        }

        public int getLootTime() {
            return this.lootTime;
        }
    }

    @ConfigSerializable
    public static class PokeStop {
        @Comment(value="Whether or not Pok\u00e9Stops spawn naturally.\n")
        private boolean enabled = true;
        @Comment(value="How often players can loot single Pok\u00e9Stop. This value is in hours.\n")
        private int lootTime = 24;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getLootTime() {
            return this.lootTime;
        }
    }
}

