/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import java.util.Arrays;
import java.util.List;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/raids.yml")
public class RaidsConfig
extends AbstractYamlConfig {
    @Comment(value="Shiny rates per raid star level\n")
    private List<Float> raidShinyChances = Arrays.asList(Float.valueOf(4096.0f), Float.valueOf(4096.0f), Float.valueOf(2048.0f), Float.valueOf(1024.0f), Float.valueOf(1024.0f));
    @Comment(value="HA rates per raid star level.\n")
    private List<Float> raidHAChances = Arrays.asList(Float.valueOf(150.0f), Float.valueOf(125.0f), Float.valueOf(100.0f), Float.valueOf(75.0f), Float.valueOf(50.0f));
    @Comment(value="Gigantamax Factor rates per raid star level.\n")
    private List<Float> raidGigantamaxFactorChances = Arrays.asList(Float.valueOf(512.0f), Float.valueOf(512.0f), Float.valueOf(512.0f), Float.valueOf(256.0f), Float.valueOf(128.0f));
    @Comment(value="Chance of a den spawning per chunk.\n")
    private float denSpawnChanceModifier = 0.3f;
    @Comment(value="Time of day (in ticks) when dens attempt to respawn their boss.\n")
    private int denRespawnTime = 100;
    @Comment(value="Chance of a den respawning their boss when the den respawn time is hit.\n")
    private float denRespawnChance = 0.75f;
    @Comment(value="Weights of each star level appearing in raids.\n")
    private List<Integer> denStarWeights = Arrays.asList(19, 12, 9, 3, 1);
    @Comment(value="Whether raids can have legendaries.\n")
    private boolean raidHaveLegendaries = true;
    @Comment(value="Whether raids can have Ultra Beasts.\n")
    private boolean raidHaveUltraBeasts = true;
    @Comment(value="Star levels at which Master Balls/Park Balls cannot be used.\n")
    private List<Boolean> raidMasterBallBlock = Arrays.asList(false, false, false, false, false);
    @Comment(value="Star levels at which only the leader of the raid has a catch attempt.\n")
    private List<Boolean> raidOnlyLeaderCanCatch = Arrays.asList(false, false, false, false, false);
    @Comment(value="Species which can never appear in raids.\n")
    private List<String> raidBlacklist = Arrays.asList("MissingNo");
    @Comment(value="Whether or not dens can be broken with repeat pickaxe hits.\n")
    private boolean raidDensBreakable = true;

    public float getRaidShinyRate(int stars) {
        int ordinal = stars - 1;
        if (this.raidShinyChances.size() > ordinal) {
            return this.raidShinyChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getShinyRate();
    }

    public float getRaidHARate(int stars) {
        int ordinal = stars - 1;
        if (this.raidHAChances.size() > ordinal) {
            return this.raidHAChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getHiddenAbilityRate();
    }

    public float getRaidGigantamaxFactorRate(int stars) {
        int ordinal = stars - 1;
        if (this.raidGigantamaxFactorChances.size() > ordinal) {
            return this.raidGigantamaxFactorChances.get(ordinal).floatValue();
        }
        return PixelmonConfigProxy.getSpawning().getGigantamaxFactorRate();
    }

    public int getRaidDropCount(int stars) {
        int ordinal = stars - 1;
        if (PixelmonConfigProxy.getGeneral().getDrops().getDenStarDrops().size() > ordinal) {
            return PixelmonConfigProxy.getGeneral().getDrops().getDenStarDrops().get(ordinal);
        }
        return 5;
    }

    public float getDenSpawnChanceModifier() {
        return this.denSpawnChanceModifier;
    }

    public int getDenRespawnTime() {
        return this.denRespawnTime;
    }

    public float getDenRespawnChance() {
        return this.denRespawnChance;
    }

    public List<Integer> getDenStarWeights() {
        return this.denStarWeights;
    }

    public boolean isRaidHaveLegendaries() {
        return this.raidHaveLegendaries;
    }

    public boolean isRaidHaveUltraBeasts() {
        return this.raidHaveUltraBeasts;
    }

    public boolean getRaidCanUseMaster(int stars) {
        if (stars == -1) {
            return false;
        }
        int ordinal = stars - 1;
        if (this.raidMasterBallBlock.size() > ordinal) {
            return this.raidMasterBallBlock.get(ordinal) == false;
        }
        return true;
    }

    public boolean getRaidCanAllCatch(int stars) {
        if (stars == -1) {
            return false;
        }
        int ordinal = stars - 1;
        if (this.raidOnlyLeaderCanCatch.size() > ordinal) {
            return this.raidOnlyLeaderCanCatch.get(ordinal) == false;
        }
        return true;
    }

    public List<String> getRaidBlacklist() {
        return this.raidBlacklist;
    }

    public boolean isRaidDensBreakable() {
        return this.raidDensBreakable;
    }
}

