/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.ui.ConfigSetting;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import com.pixelmonmod.pixelmon.api.util.helpers.JavaHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/config.yml")
public class GeneralConfig
extends AbstractYamlConfig {
    @Comment(value="The amount of Pok\u00e9Dollars the player will have when joining a world for the first time\n")
    private double startingBalance = 0.0;
    @Comment(value="Whether defeating wild pok\u00e9mon awards the player with the respective pok\u00e9mon Photo.\n")
    private boolean awardTokens = false;
    @Comment(value="Whether or not the player can nickname owned Pok\u00e9mon. On a server, this will prevent nicknames from being visible to other players.\n")
    private boolean allowPokemonNicknames = true;
    @Comment(value="Whether or not regular Minecraft mobs like cows and zombies can spawn naturally. DANGER - can kill you while battling.\n Monster spawners containing zombies, skeletons, or spiders will be converted into monsters spawners that spawn pigs if this setting is disabled.\n Other monster spawners (including ones that spawn hostile mobs like Blazes, cave spiders, or silverfish) will not be affected, nor will spawn eggs.\n The Ender dragon also spawns naturally regardless of this setting. Warning: This setting when not refined with a datapack will use the default\n  spawning logic instead of the implemented Betterspawner logic, possibly causing mob spam.\n\n   In order to refine the replacement logic, a datapack must be used.\n")
    private boolean allowVanillaMobs = false;
    @Comment(value="Whether or not players are allowed to throw Pok\u00e9 Balls and capture Pok\u00e9mon outside of battle.\n")
    private boolean allowCaptureOutsideBattle = true;
    @Comment(value="If enabled, Pok\u00e9mon spawned from /pokegive or from any pokespec have the possibility of containing Legendary Pok\u00e9mon.\n")
    private boolean allowRandomPokemonToBeLegendary = true;
    @Comment(value="How much growth varies the size of Pok\u00e9mon. This value can range from 0-2; if set to 0, growth will have no effect on Pok\u00e9mon size.\n")
    @ConfigSetting(minValue=0.0, maxValue=2.0, useSlider=true)
    private double growthScaleModifier = 1.0;
    @Comment(value="Whether or not Apricorns can be planted by players. This does not remove existing Apricorn trees or prevent natural Apricorn tree generation.\n")
    private boolean allowPlanting = true;
    @Comment(value="Whether or not cloning machines can be crafted and used. Disabling this setting prevents Mewtwo from being legitimately obtainable.\n")
    private boolean cloningMachineEnabled = true;
    @Comment(value="Sets The number of times a Azelf, Mesprit and Uxie can enchant a ruby.\n")
    @ConfigSetting(minValue=0.0)
    private int lakeTrioMaxEnchants = 3;
    @Comment(value="If enabled, battles between players can be initiated by a player throwing a Pok\u00e9mon's Pok\u00e9 Ball at another player directly (rather than at the other player's Pok\u00e9mon).\n")
    private boolean engagePlayerByPokeBall = true;
    @Comment(value="Whether or not aggressive wild Pok\u00e9mon initiate battles against players.\n")
    private boolean enableWildAggression = true;
    @Comment(value="Whether Legendary shrines, such as the Legendary Bird or Timespace Trio shrines, can be used multiple times. The Different Modes are as Follows:\n  - Once - A shrine can only be used once globally\n  - OncePerPlayer - a shrine may only be used once per player\n  - OncePerMCDAy a shrine may be used once per Minecraft day (20 minutes)\n  - OncePerDay - a shrine may only be used once per 24 hours\n  - Unlimited - a shrine may be used indefinitely\n")
    private EnumEncounterMode shrineEncounterMode = EnumEncounterMode.Once;
    @Comment(value="Whether or not players have to be ops to edit Pixelmon spawners. If this option is disabled, any player in Creative mode can edit spawners.\n")
    private boolean spawnersOpOnly = true;
    @Comment(value="If set to true, must be opped to use the NPC Editor. If false, must be in Creative mode.\n")
    private boolean npcEditorOpOnly = true;
    @Comment(value="If true, must be opped to use the Quest Editor. If false, must be in Creative mode.\n")
    private boolean questEditorOpOnly = true;
    @Comment(value="Whether or not traders can be used multiple times. If disabled, traders will disappear after completing their trade offers.\n")
    private boolean tradersReusable = false;
    @Comment(value="The amount of moves a Move Tutor will have.\n")
    private int movesPerTutor = 20;
    @Comment(value="Whether or not Minecraft time will sync to real time (as defined by the machine's system time).\n")
    private boolean useSystemTimeForWorldTime = false;
    @Comment(value="How often Minecraft time will sync to real time (in seconds) if real time syncing is enabled.\n")
    private int timeUpdateInterval = 30;
    @Comment(value="Whether or not players can use Pok\u00e9mon editors. When disabled client-side, this will prevent other players from using Pok\u00e9mon editors on the player with the setting disabled.\n")
    private boolean allowPokemonEditors = true;
    @Comment(value="Whether or not players can place statues using a Chisel.\n")
    private boolean allowChisels = true;
    @Comment(value="The maximum level that a Pok\u00e9mon can be.\n")
    @ConfigSetting(minValue=1.0)
    private int maxLevel = 100;
    @Comment(value="Whether or not out-of-battle wild Pok\u00e9mon can be hurt by minecraft attacks such as punching or swords.\n")
    private boolean canPokemonBeHit = false;
    @Comment(value="Whether or not players will automatically have a Mega ring.\n")
    private boolean alwaysHaveMegaRing = false;
    @Comment(value="Whether or not players will automatically have a Dynamax band.\n")
    private boolean alwaysHaveDynamaxBand = false;
    @Comment(value="The chance of obtaining a Sir Doofus III from catching a Bidoof with a Luxury Ball. (1/x chance, -1 to disable)\n")
    private int chanceToGetSpecialBidoof = 30;
    @Comment(value="Determines if non player owned pokemon's movement is disabled or not.\n")
    private boolean disabledNonPlayerMovement = false;
    @Comment(value="Determines the catch formula used in the official game of that generation.\n")
    private String fallbackCaptureMethod = "gen8";
    @Comment(value="If enabled, unlocks the Shiny Charm upon Pok\u00e9dex completion.\n")
    private boolean allowShinyCharmFromPokedex = true;
    @Comment(value="Enables unlocking the Oval Charm upon completion of a regional Pok\u00e9dex.\n")
    private boolean allowOvalCharmFromPokedex = true;
    @Comment(value="Experience multiplier when an Exp. Charm is equipped.\n")
    private double expCharmMultiplier = 1.5;
    @Comment(value="Multiplier of the chance that a critical capture will occur when a Catching Charm is equipped.\n")
    private double catchingCharmMultiplier = 1.1;
    @Comment(value="Number of rolls for a wild Pok\u00e9mon to gain a mark when a Mark Charm is equipped.\n")
    private int markCharmRolls = 3;
    @Comment(value="Multiplier of durability loss for each use of the hammer.\n")
    @ConfigSetting(minValue=1.0)
    private int hammerDurabilityLossMultiplier = 3;
    @Comment(value="The colour that will appear when the player uses ore sense\n")
    private Map<String, OreColor> oreColors = new HashMap<String, OreColor>(){
        {
            this.put("0", new OreColor("minecraft:coal_ore", Integer.parseInt("E2C0AA", 16), 22));
            this.put("1", new OreColor("minecraft:iron_ore", Integer.parseInt("E2C0AA", 16), 18));
            this.put("2", new OreColor("minecraft:copper_ore", Integer.parseInt("FF873F", 16), 24));
            this.put("3", new OreColor("minecraft:gold_ore", Integer.parseInt("FCEE4B", 16), 21));
            this.put("4", new OreColor("minecraft:redstone_ore", Integer.parseInt("FF0000", 16), 20));
            this.put("5", new OreColor("minecraft:emerald_ore", Integer.parseInt("17DD62", 16), 19));
            this.put("6", new OreColor("minecraft:diamond_ore", Integer.parseInt("65F5E3", 16), 0));
            this.put("7", new OreColor("minecraft:lapis_ore", Integer.parseInt("1855BD", 16), 2));
            this.put("8", new OreColor("minecraft:nether_gold_ore", Integer.parseInt("FCEE4B", 16), 23));
            this.put("9", new OreColor("minecraft:nether_quartz_ore", Integer.parseInt("EAE5DE", 16), 3));
            this.put("10", new OreColor("minecraft:deepslate_coal_ore", Integer.parseInt("E2C0AA", 16), 22));
            this.put("11", new OreColor("minecraft:deepslate_iron_ore", Integer.parseInt("E2C0AA", 16), 18));
            this.put("12", new OreColor("minecraft:deepslate_copper_ore", Integer.parseInt("FF873F", 16), 24));
            this.put("13", new OreColor("minecraft:deepslate_gold_ore", Integer.parseInt("FCEE4B", 16), 21));
            this.put("14", new OreColor("minecraft:deepslate_redstone_ore", Integer.parseInt("FF0000", 16), 20));
            this.put("15", new OreColor("minecraft:deepslate_emerald_ore", Integer.parseInt("17DD62", 16), 19));
            this.put("16", new OreColor("minecraft:deepslate_diamond_ore", Integer.parseInt("65F5E3", 16), 0));
            this.put("17", new OreColor("minecraft:deepslate_lapis_ore", Integer.parseInt("1855BD", 16), 2));
            this.put("19", new OreColor("pixelmon:ruby_ore", Integer.parseInt("DD1C33", 16), 1));
            this.put("20", new OreColor("pixelmon:sapphire_ore", Integer.parseInt("4A73E7", 16), 1));
            this.put("21", new OreColor("pixelmon:crystal_ore", Integer.parseInt("AFEEEE", 16), 1));
            this.put("22", new OreColor("pixelmon:bauxite_ore", Integer.parseInt("D1B584", 16), 0));
            this.put("23", new OreColor("pixelmon:silver_ore", Integer.parseInt("E2E2E2", 16), 16));
            this.put("24", new OreColor("pixelmon:platinum_ore", Integer.parseInt("8EB2F2", 16), 17));
            this.put("25", new OreColor("pixelmon:silicon_ore", Integer.parseInt("E2DFEE", 16), 0));
            this.put("26", new OreColor("pixelmon:fossil", Integer.parseInt("443D32", 16), 6));
            this.put("27", new OreColor("pixelmon:sun_stone_ore", Integer.parseInt("E57742", 16), 5));
            this.put("28", new OreColor("pixelmon:moon_stone_ore", Integer.parseInt("5A858B", 16), 14));
            this.put("29", new OreColor("pixelmon:dawn_stone_ore", Integer.parseInt("000000", 16), 7));
            this.put("30", new OreColor("pixelmon:dusk_stone_ore", Integer.parseInt("000000", 16), 7));
            this.put("31", new OreColor("pixelmon:water_stone_ore", Integer.parseInt("5D719F", 16), 8));
            this.put("32", new OreColor("pixelmon:thunder_stone_ore", Integer.parseInt("F0FF01", 16), 9));
            this.put("33", new OreColor("pixelmon:leaf_stone_ore", Integer.parseInt("7EA167", 16), 10));
            this.put("34", new OreColor("pixelmon:fire_stone_ore", Integer.parseInt("CC7132", 16), 11));
            this.put("35", new OreColor("pixelmon:shiny_stone_ore", Integer.parseInt("FAFFA3", 16), 5));
            this.put("36", new OreColor("pixelmon:ice_stone_ore", Integer.parseInt("C9B0CF", 16), 15));
        }
    };
    @Comment(value="How many ticks it will take for a lure to expire on average.\n")
    private int averageLureExpiryTicks = 17920;
    @Comment(value="If set to False, this will be based on the remaining inventory of the player.\n")
    private boolean limitShopKeeperStackSize = true;
    @Comment(value="Which dimensions use Gen 7 features (eg. Mega Bosses). Any other dimension will use Gen 8 (eg. Max Raids).\n")
    private List<String> oldGenDimensions = Lists.newArrayList();
    @Comment(value="Which dimensions use both Gen 7 and Gen 8 features. Overrides other options that would affect this otherwise.\n")
    private List<String> bothGenDimensions = Lists.newArrayList((Object[])new String[]{"pixelmon:ultra_space", "pixelmon:drowned", "minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"});
    @Comment(value="Height of Dynamax and Gigantamax in blocks.\n")
    private float dynamaxSize = 15.0f;
    @Comment(value="Whether berry juices can be crafted in the infuser or not.\n")
    private boolean berryJuiceCrafting = true;
    @Comment(value="If enabled, Pok\u00e9 Gifts will remain after players claim them, but each Pok\u00e9 Gift can only be claimed once per player. If disabled, claiming a Pok\u00e9 Gift will cause it to disappear.\n")
    private boolean pokeGiftReusable = false;
    @Comment(value="The maximum distance that two elevators can link together at.\n")
    private int elevatorSearchRange = 10;
    @Comment(value="Whether or not players will pick their starter Pok\u00e9mon immediately upon entering a world.\n")
    private boolean starterOnJoin = true;
    @Comment(value="If the discord rich presence should be enabled\n")
    private boolean useDiscordRichPresence = !JavaHelper.isAndroid();
    @Comment(value="Server Discord Information\n")
    private ServerDiscord serverDiscord = new ServerDiscord();
    private Debug debug = new Debug();
    private TMHM tms = new TMHM();
    private Drops drops = new Drops();
    private Healing healing = new Healing();
    private AFKHandler afkHandler = new AFKHandler();
    private Pokerus pokerus = new Pokerus();
    private Riding riding = new Riding();
    private OutsideEffects outsideEffects = new OutsideEffects();

    public int getHammerDurabilityLossMultiplier() {
        return this.hammerDurabilityLossMultiplier;
    }

    public void setHammerDurabilityLossMultiplier(int hammerDurabilityLossMultiplier) {
        this.hammerDurabilityLossMultiplier = hammerDurabilityLossMultiplier;
    }

    public double getStartingBalance() {
        return this.startingBalance;
    }

    public boolean isAwardTokens() {
        return this.awardTokens;
    }

    public boolean isAllowPokemonNicknames() {
        return this.allowPokemonNicknames;
    }

    public boolean isAllowVanillaMobs() {
        return this.allowVanillaMobs;
    }

    public boolean isAllowCaptureOutsideBattle() {
        return this.allowCaptureOutsideBattle;
    }

    public boolean isAllowRandomPokemonToBeLegendary() {
        return this.allowRandomPokemonToBeLegendary;
    }

    public double getGrowthScaleModifier() {
        return this.growthScaleModifier;
    }

    public boolean isAllowPlanting() {
        return this.allowPlanting;
    }

    public boolean isCloningMachineEnabled() {
        return this.cloningMachineEnabled;
    }

    public int getLakeTrioMaxEnchants() {
        return this.lakeTrioMaxEnchants;
    }

    public boolean isEngagePlayerByPokeBall() {
        return this.engagePlayerByPokeBall;
    }

    public boolean isEnableWildAggression() {
        return this.enableWildAggression;
    }

    public EnumEncounterMode getShrineEncounterMode() {
        return this.shrineEncounterMode;
    }

    public boolean isSpawnersOpOnly() {
        return this.spawnersOpOnly;
    }

    public boolean isNpcEditorOpOnly() {
        return this.npcEditorOpOnly;
    }

    public boolean isQuestEditorOpOnly() {
        return this.questEditorOpOnly;
    }

    public boolean isTradersReusable() {
        return this.tradersReusable;
    }

    public int getMovesPerTutor() {
        return this.movesPerTutor;
    }

    public boolean isUseSystemTimeForWorldTime() {
        return this.useSystemTimeForWorldTime;
    }

    public int getTimeUpdateInterval() {
        return this.timeUpdateInterval;
    }

    public boolean isAllowPokemonEditors() {
        return this.allowPokemonEditors;
    }

    public boolean isAllowChisels() {
        return this.allowChisels;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public boolean isCanPokemonBeHit() {
        return this.canPokemonBeHit;
    }

    public boolean isAlwaysHaveMegaRing() {
        return this.alwaysHaveMegaRing;
    }

    public boolean isAlwaysHaveDynamaxBand() {
        return this.alwaysHaveDynamaxBand;
    }

    public int getChanceToGetSpecialBidoof() {
        return this.chanceToGetSpecialBidoof;
    }

    public boolean isDisabledNonPlayerMovement() {
        return this.disabledNonPlayerMovement;
    }

    public boolean isAllowShinyCharmFromPokedex() {
        return this.allowShinyCharmFromPokedex;
    }

    public boolean isAllowOvalCharmFromPokedex() {
        return this.allowOvalCharmFromPokedex;
    }

    public double getExpCharmMultiplier() {
        return this.expCharmMultiplier;
    }

    public double getCatchingCharmMultiplier() {
        return this.catchingCharmMultiplier;
    }

    public int getMarkCharmRolls() {
        return this.markCharmRolls;
    }

    public List<OreColor> getOreColors() {
        return Lists.newArrayList(this.oreColors.values());
    }

    public OreColor getEntryForBlock(String registryName) {
        for (OreColor value : this.oreColors.values()) {
            if (!value.getBlockId().equalsIgnoreCase(registryName)) continue;
            return value;
        }
        return null;
    }

    public int getAverageLureExpiryTicks() {
        return this.averageLureExpiryTicks;
    }

    public boolean isLimitShopKeeperStackSize() {
        return this.limitShopKeeperStackSize;
    }

    public int getShopMaxStackSize(ItemStack stack) {
        if (this.isLimitShopKeeperStackSize()) {
            return stack == null ? 64 : stack.m_41741_();
        }
        return 2304;
    }

    public List<String> getOldGenDimensions() {
        return this.oldGenDimensions;
    }

    public List<String> getBothGenDimensions() {
        return this.bothGenDimensions;
    }

    public float getDynamaxSize() {
        return this.dynamaxSize;
    }

    public boolean isBerryJuiceCrafting() {
        return this.berryJuiceCrafting;
    }

    public boolean isPokeGiftReusable() {
        return this.pokeGiftReusable;
    }

    public int getElevatorSearchRange() {
        return this.elevatorSearchRange;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public TMHM getTMs() {
        return this.tms;
    }

    public Drops getDrops() {
        return this.drops;
    }

    public Healing getHealing() {
        return this.healing;
    }

    public AFKHandler getAfkHandler() {
        return this.afkHandler;
    }

    public Pokerus getPokerus() {
        return this.pokerus;
    }

    public Riding getRiding() {
        return this.riding;
    }

    public OutsideEffects getOutsideEffects() {
        return this.outsideEffects;
    }

    public boolean usesGen8Features(ResourceKey<Level> dimension) {
        return this.getBothGenDimensions().contains(dimension.m_135782_().toString()) || !this.getOldGenDimensions().contains(dimension.m_135782_().toString());
    }

    public boolean isStarterOnJoin() {
        return this.starterOnJoin;
    }

    public String getFallbackCaptureMethod() {
        return this.fallbackCaptureMethod;
    }

    public boolean isUseDiscordRichPresence() {
        return this.useDiscordRichPresence;
    }

    public ServerDiscord getServerDiscord() {
        return this.serverDiscord;
    }

    @ConfigSerializable
    public static class ServerDiscord {
        @Comment(value="If you want your server's Discord invite to appear in the rich presence, put it here.\nThis can also accept a URL so you can link to a website instead.\nIt will only appear when the discord-invite setting is not a blank string.\n")
        private String discordInvite = "";
        @Comment(value="The server name to show on the button\n")
        private String serverName = "My Pixelmon Server!";

        public ServerDiscord() {
        }

        public ServerDiscord(String discordInvite, String serverName) {
            this.discordInvite = discordInvite;
            this.serverName = serverName;
        }

        public String getDiscordInvite() {
            return this.discordInvite;
        }

        public String getServerName() {
            return this.serverName;
        }
    }

    @ConfigSerializable
    public static class Debug {
        @Comment(value="If this option is enabled, any Pixelmon-related errors on a server will be printed to the server log in detail. If disabled, errors will be much shorter and less detailed.\n")
        private boolean printErrors = true;
        @Comment(value="Whether to use the fix for clumping Pok\u00e9mon around the edges of the world. If you are on Sponge, or don't know what it is, keep it off.\n")
        private boolean useUpdateEntityWithOptionalForceFix = false;
        @Comment(value="Verbose Logging - Keep this off unless you are diagnosing issues.\n")
        private boolean verbose = false;

        public boolean isPrintErrors() {
            return this.printErrors;
        }

        public boolean isUseUpdateEntityWithOptionalForceFix() {
            return this.useUpdateEntityWithOptionalForceFix;
        }

        public boolean isVerbose() {
            return this.verbose;
        }
    }

    @ConfigSerializable
    public static class TMHM {
        private boolean allowTMReuse = true;
        private boolean allowTRReuse = false;
        private boolean universalTMs = true;
        private boolean superUniversalTMs = false;

        public boolean isAllowTMReuse() {
            return this.allowTMReuse;
        }

        public boolean isAllowTRReuse() {
            return this.allowTRReuse;
        }

        public boolean isUniversalTMs() {
            return this.universalTMs;
        }

        public boolean isSuperUniversalTMs() {
            return this.superUniversalTMs;
        }
    }

    @ConfigSerializable
    public static class Drops {
        @Comment(value="Whether or not certain Pok\u00e9mon can drop items upon defeat.\n")
        private boolean pokemonDropsEnabled = true;
        @Comment(value="If enabled, the drops GUI will display after the player defeats a regular wild Pok\u00e9mon. The drops GUI will always display when defeating NPC Trainers or boss Pok\u00e9mon, regardless of this setting.\n")
        private boolean useDropGUI = true;
        @Comment(value="Whether or not the \"Drop All\" button in the Pok\u00e9mon drops screen will delete the items or drop them on the ground.\n")
        private boolean deleteUnwantedDrops = false;
        @Comment(value="Number of item drops for each star level in raids.\n")
        private List<Integer> denStarDrops = Arrays.asList(2, 4, 6, 8, 10);

        public boolean isPokemonDropsEnabled() {
            return this.pokemonDropsEnabled;
        }

        public boolean isUseDropGUI() {
            return this.useDropGUI;
        }

        public boolean isDeleteUnwantedDrops() {
            return this.deleteUnwantedDrops;
        }

        public List<Integer> getDenStarDrops() {
            return this.denStarDrops;
        }
    }

    @ConfigSerializable
    public static class Healing {
        @Comment(value="Whether or not beds will fully heal Pok\u00e9mon when slept in.\n")
        private boolean bedsHealPokemon = true;
        @Comment(value="Whether to passively heal party Pok\u00e9mon over time or not.\n")
        private boolean usePassiveHealer = true;
        @Comment(value="Chance to passively revive a knocked out party Pok\u00e9mon with each step.\n")
        private float chanceToRevivePassively = 0.001f;
        @Comment(value="Chance to passively heal status effects from a party Pok\u00e9mon with each step.\n")
        private float chanceToHealStatusPassively = 0.005f;
        @Comment(value="Number of steps after which to heal 1 HP from a party Pok\u00e9mon.\n")
        private int stepsToHealHealthPassively = 75;
        @Comment(value="Percentage of maximum health that the passive heal can go up to.\n")
        private float passiveHealingMaxHealthPercentage = 0.25f;

        public boolean isBedsHealPokemon() {
            return this.bedsHealPokemon;
        }

        public boolean isUsePassiveHealer() {
            return this.usePassiveHealer;
        }

        public float getChanceToRevivePassively() {
            return this.chanceToRevivePassively;
        }

        public float getChanceToHealStatusPassively() {
            return this.chanceToHealStatusPassively;
        }

        public int getStepsToHealHealthPassively() {
            return this.stepsToHealHealthPassively;
        }

        public float getPassiveHealingMaxHealthPercentage() {
            return this.passiveHealingMaxHealthPercentage;
        }
    }

    @ConfigSerializable
    public static class AFKHandler {
        @Comment(value="Whether or not the AFK handler is enabled.\n")
        private boolean enabled = false;
        @Comment(value="The amount of time (in seconds) that a player can be unresponsive in battle before the AFK handler takes control.\n")
        private int afkActivateSeconds = 90;
        @Comment(value="The amount of time that the AFK handler takes to make a move.\n")
        private int afkTimerTurnSeconds = 15;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getAfkActivateSeconds() {
            return this.afkActivateSeconds;
        }

        public int getAfkTimerTurnSeconds() {
            return this.afkTimerTurnSeconds;
        }
    }

    @ConfigSerializable
    public static class Pokerus {
        @Comment(value="Whether or not the Pok\u00e9rus is enabled. This blocks the growth, the spread and the spawning of the Pok\u00e9rus.\n")
        private boolean enabled = true;
        @Comment(value="Pok\u00e9rus spawn rate (1/x). (0 to disable)\n")
        private float spawnRate = 12288.0f;
        @Comment(value="Whether or not the player should be informed if their Pok\u00e9mon got Pok\u00e9rus.\n")
        private boolean informPlayers = true;
        @Comment(value="Chance to spread the Pok\u00e9rus to the near Pok\u00e9mon after a battle. (1/x) (-1 to disable; 0 to keep always active)\n")
        private int spreadRate = 5;

        public boolean shouldCatchPokerus() {
            if (!this.enabled || this.getSpawnRate() <= 0.0f) {
                return false;
            }
            return RandomHelper.getRandomChance(1.0f / this.spawnRate);
        }

        @Deprecated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Deprecated
        public float getSpawnRate() {
            return this.spawnRate;
        }

        public boolean isInformPlayers() {
            return this.informPlayers;
        }

        public int getSpreadRate() {
            return this.spreadRate;
        }
    }

    @ConfigSerializable
    public static class Riding {
        @Comment(value="Allow players to ride Pok\u00e9mon. If false, no Pok\u00e9mon can be ridden.\n")
        private boolean allowRiding = true;
        @Comment(value="A multiplier for the mounting speed of Pok\u00e9mon. Can be between 0 and 1, where 1 is the default mounting speed.\n")
        private float ridingSpeedMultiplier = 1.0f;
        @Comment(value="If enabled, this option causes a mounted Pok\u00e9mon to be steered by moving the camera, matching the directional controls on foot. If disabled, mounted Pok\u00e9mon are steered using the keybinds for moving left and right.\n")
        private boolean enablePointToSteer = true;
        @Comment(value="If enabled, allows riding Pok\u00e9mon mounts that do not have the ability to fly or surf.\n")
        private boolean landMount = true;
        @Comment(value="Whether or not Fly or Surf must be known by a water or flying mounted Pok\u00e9mon in order to mount it. Land mounts are unaffected by this setting.\n")
        private boolean requireHM = false;
        @Comment(value="Sets the flying speed limit for a mounted Pok\u00e9mon in the new flying system.\n")
        private float flyingSpeedLimit = 4.0f;

        public boolean isAllowRiding() {
            return this.allowRiding;
        }

        public float getRidingSpeedMultiplier() {
            return this.ridingSpeedMultiplier;
        }

        public boolean isEnablePointToSteer() {
            return this.enablePointToSteer;
        }

        public boolean isLandMount() {
            return this.landMount;
        }

        public boolean isRequireHM() {
            return this.requireHM;
        }

        public float getFlyingSpeedLimit() {
            return this.flyingSpeedLimit;
        }
    }

    @ConfigSerializable
    public static class OutsideEffects {
        @Comment(value="Whether or not outside effects is enabled or disabled.\n")
        private boolean useOutsideEffects = true;
        @Comment(value="Amount of steps for effects such as Poison to be applied.\n")
        private int stepsToApplyEffects = 15;
        @Comment(value="The maximum amount of damage Poison can do outside of battle to a poisoned Pok\u00e9mon.\n")
        private int poisonMaxDamage = 5;

        public boolean isUseOutsideEffects() {
            return this.useOutsideEffects;
        }

        public int getStepsToApplyEffects() {
            return this.stepsToApplyEffects;
        }

        public int getPoisonMaxDamage() {
            return this.poisonMaxDamage;
        }
    }

    @ConfigSerializable
    public static class OreColor {
        private String blockId;
        private int color;
        private int pattern;

        public OreColor(String blockId, int color, int pattern) {
            this.blockId = blockId;
            this.color = color;
            this.pattern = pattern;
        }

        public OreColor() {
        }

        public String getBlockId() {
            return this.blockId;
        }

        public int getColor() {
            return this.color;
        }

        public int getPattern() {
            return this.pattern;
        }
    }
}

