/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;

public class FormLogRegistry {
    private static final Map<RegistryValue<Species>, LinkedHashMultimap<Integer, PokemonSpecification>> REGISTRY = Maps.newHashMap();

    public static void init() {
        REGISTRY.clear();
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 0, PokemonSpecificationProxy.create("palette:none").get(), PokemonSpecificationProxy.create("palette:skelly").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 1, PokemonSpecificationProxy.create("palette:calico_orange_white").get(), PokemonSpecificationProxy.create("palette:calico_orange_white_black").get(), PokemonSpecificationProxy.create("palette:calico_white_orange").get(), PokemonSpecificationProxy.create("palette:calico_orange_gold").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 2, PokemonSpecificationProxy.create("palette:orange_twotone").get(), PokemonSpecificationProxy.create("palette:orange_orca").get(), PokemonSpecificationProxy.create("palette:orange_dapples").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 3, PokemonSpecificationProxy.create("palette:pink_twotone").get(), PokemonSpecificationProxy.create("palette:pink_orca").get(), PokemonSpecificationProxy.create("palette:pink_dapples").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 4, PokemonSpecificationProxy.create("palette:gray_bubbles").get(), PokemonSpecificationProxy.create("palette:gray_diamonds").get(), PokemonSpecificationProxy.create("palette:gray_patches").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 5, PokemonSpecificationProxy.create("palette:purple_bubbles").get(), PokemonSpecificationProxy.create("palette:purple_diamonds").get(), PokemonSpecificationProxy.create("palette:purple_patches").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 6, PokemonSpecificationProxy.create("palette:apricot_tiger").get(), PokemonSpecificationProxy.create("palette:apricot_zebra").get(), PokemonSpecificationProxy.create("palette:apricot_stripes").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 7, PokemonSpecificationProxy.create("palette:brown_tiger").get(), PokemonSpecificationProxy.create("palette:brown_zebra").get(), PokemonSpecificationProxy.create("palette:brown_stripes").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 8, PokemonSpecificationProxy.create("palette:orange_forehead").get(), PokemonSpecificationProxy.create("palette:orange_mask").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 9, PokemonSpecificationProxy.create("palette:black_forehead").get(), PokemonSpecificationProxy.create("palette:black_mask").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 10, PokemonSpecificationProxy.create("palette:blue_saucy").get(), PokemonSpecificationProxy.create("palette:blue_raindrops").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 11, PokemonSpecificationProxy.create("palette:violet_saucy").get(), PokemonSpecificationProxy.create("palette:violet_raindrops").get());
        FormLogRegistry.createCategory(PixelmonSpecies.MAGIKARP, 12, PokemonSpecificationProxy.create("palette:shiny").get(), PokemonSpecificationProxy.create("palette:roasted").get(), PokemonSpecificationProxy.create("palette:valencian").get());
        FormLogRegistry.createCategory(PixelmonSpecies.SHELLOS, 0, PokemonSpecificationProxy.create("form:east palette:none").get(), PokemonSpecificationProxy.create("form:east palette:shiny").get(), PokemonSpecificationProxy.create("form:east palette:gray_bubbles").get(), PokemonSpecificationProxy.create("form:east palette:purple_bubbles").get(), PokemonSpecificationProxy.create("form:east palette:violet_saucy").get(), PokemonSpecificationProxy.create("form:east palette:apricot_saucy").get(), PokemonSpecificationProxy.create("form:east palette:moons").get(), PokemonSpecificationProxy.create("form:east palette:golde").get());
        FormLogRegistry.createCategory(PixelmonSpecies.SHELLOS, 1, PokemonSpecificationProxy.create("form:west palette:none").get(), PokemonSpecificationProxy.create("form:west palette:shiny").get(), PokemonSpecificationProxy.create("form:west palette:gray_diamonds").get(), PokemonSpecificationProxy.create("form:west palette:purple_diamonds").get(), PokemonSpecificationProxy.create("form:west palette:brown_stripes").get(), PokemonSpecificationProxy.create("form:west palette:blue_stripes").get(), PokemonSpecificationProxy.create("form:west palette:sun").get(), PokemonSpecificationProxy.create("form:west palette:goldw").get());
        FormLogRegistry.createCategory(PixelmonSpecies.CLOBBOPUS, 0, PokemonSpecificationProxy.create("palette:none").get(), PokemonSpecificationProxy.create("palette:irish").get(), PokemonSpecificationProxy.create("palette:diamonds").get(), PokemonSpecificationProxy.create("palette:clubs").get(), PokemonSpecificationProxy.create("palette:martian").get(), PokemonSpecificationProxy.create("palette:starry").get(), PokemonSpecificationProxy.create("palette:yellow_ringed").get(), PokemonSpecificationProxy.create("palette:red_ringed").get(), PokemonSpecificationProxy.create("palette:alien").get(), PokemonSpecificationProxy.create("palette:shiny").get());
        FormLogRegistry.createCategory(PixelmonSpecies.SPHEAL, 0, PokemonSpecificationProxy.create("palette:none").get(), PokemonSpecificationProxy.create("palette:pokeball").get(), PokemonSpecificationProxy.create("palette:duskball").get(), PokemonSpecificationProxy.create("palette:loveball").get(), PokemonSpecificationProxy.create("palette:friendball").get(), PokemonSpecificationProxy.create("palette:heavyball").get(), PokemonSpecificationProxy.create("palette:moonball").get(), PokemonSpecificationProxy.create("palette:premierball").get(), PokemonSpecificationProxy.create("palette:masterball").get(), PokemonSpecificationProxy.create("palette:gsball").get(), PokemonSpecificationProxy.create("palette:shiny").get());
        FormLogRegistry.createCategory(PixelmonSpecies.SLUGMA, 0, PokemonSpecificationProxy.create("palette:none").get(), PokemonSpecificationProxy.create("palette:copper_sulfate").get(), PokemonSpecificationProxy.create("palette:cupric_chloride").get(), PokemonSpecificationProxy.create("palette:lithium_chloride").get(), PokemonSpecificationProxy.create("palette:magnesium_sulfide").get(), PokemonSpecificationProxy.create("palette:manganese_chloride").get(), PokemonSpecificationProxy.create("palette:potassium_chloride").get(), PokemonSpecificationProxy.create("palette:sodium_carbonate").get(), PokemonSpecificationProxy.create("palette:calcium_carbonate").get(), PokemonSpecificationProxy.create("palette:shiny").get());
    }

    public static Stream<Species> getSpeciesList() {
        return REGISTRY.keySet().stream().map(RegistryValue::getValueUnsafe).sorted();
    }

    public static LinkedHashMultimap<Integer, PokemonSpecification> getFormsForSpecies(Species species) {
        return REGISTRY.getOrDefault(species.getRegistryValue(), (LinkedHashMultimap<Integer, PokemonSpecification>)LinkedHashMultimap.create());
    }

    public static int getFormId(Species species, PokemonSpecification palette) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return specs.indexOf(palette);
    }

    public static int getFirstIdFromPokemon(Pokemon pokemon) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(pokemon.getSpecies());
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        for (int i = 0; i < specs.size(); ++i) {
            if (!((PokemonSpecification)specs.get(i)).matches(pokemon)) continue;
            return i;
        }
        return -1;
    }

    public static PokemonSpecification getFormFromId(Species species, int id) {
        LinkedHashMultimap<Integer, PokemonSpecification> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return (PokemonSpecification)specs.get(id);
    }

    public static void createCategory(RegistryValue<Species> species, int category, PokemonSpecification ... palettes) {
        if (!REGISTRY.containsKey(species)) {
            REGISTRY.put(species, (LinkedHashMultimap<Integer, PokemonSpecification>)LinkedHashMultimap.create());
        }
        Multimap map = (Multimap)REGISTRY.get(species);
        map.putAll((Object)category, (Iterable)Lists.newArrayList((Object[])palettes));
    }

    public static int[] getData(ServerPlayer target, Species species) {
        Map<Short, Short> cells = StorageProxy.getPartyNow((ServerPlayer)target).playerPokedex.seenForms(species);
        int[] data = new int[FormLogRegistry.getFormsForSpecies(species).size()];
        cells.forEach((key, value) -> {
            data[key.shortValue()] = value.shortValue();
        });
        return data;
    }

    public static int[] getMenuData(ServerPlayer playerIn) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(REGISTRY.size());
        FormLogRegistry.getSpeciesList().forEachOrdered(species -> {
            list.add(species.getDex());
            int[] data = FormLogRegistry.getData(playerIn, species);
            list.add(data.length);
            for (int i : data) {
                list.add(i);
            }
        });
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static void assignRandomFish(SpawnActionPokemon spawnPokemon) {
        RegistryValue<Species> species = RandomHelper.getRandomElementFromCollection(REGISTRY.keySet());
        spawnPokemon.pokemon.setSpecies(species, true);
        spawnPokemon.pokemon.initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC);
        spawnPokemon.pokemon.getMoveset().clear();
        ((PokemonSpecification)RandomHelper.getRandomElementFromCollection(REGISTRY.get(species).values())).apply(spawnPokemon.pokemon);
    }
}

