/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleAIMode;
import com.pixelmonmod.pixelmon.api.config.ForceBattleEndResult;
import com.pixelmonmod.pixelmon.api.config.api.data.ConfigPath;
import com.pixelmonmod.pixelmon.api.config.api.yaml.AbstractYamlConfig;
import info.pixelmon.repack.org.spongepowered.objectmapping.ConfigSerializable;
import info.pixelmon.repack.org.spongepowered.objectmapping.meta.Comment;
import java.util.List;

@ConfigSerializable
@ConfigPath(value="config/pixelmon/battle.yml")
public class BattleConfig
extends AbstractYamlConfig {
    @Comment(value="The type of battle AI that the wild Pokemon will use. The options are:\n - RANDOM - The pokemon will use moves randomly\n - AGGRESSIVE - The pokemon will use the move that will deal the most damage, and avoid status moves\n - TACTICAL - The pokemon will know ho wot use status moves with offensive moves\n - ADVANCED - The pokemon will do everything from tactical and also know when to switch\n")
    private BattleAIMode battleAIWild = BattleAIMode.RANDOM;
    @Comment(value="The type of battle AI that the boss pokemon will use. The options are:\n - RANDOM - The pokemon will use moves randomly\n - AGGRESSIVE - The pokemon will use the move that will deal the most damage, and avoid status moves\n - TACTICAL - The pokemon will know ho wot use status moves with offensive moves\n - ADVANCED - The pokemon will do everything from tactical and also know when to switch\n")
    private BattleAIMode battleAIBoss = BattleAIMode.AGGRESSIVE;
    @Comment(value="The type of battle AI that the naturally spawning trainers will use. The options are:\n - RANDOM - The trainer will use moves randomly\n - AGGRESSIVE - The trainer will use the move that will deal the most damage, and avoid status moves\n - TACTICAL - The trainer will know ho wot use status moves with offensive moves\n - ADVANCED - The trainer will do everything from tactical and also know when to switch\n")
    private BattleAIMode battleAITrainer = BattleAIMode.TACTICAL;
    @Comment(value="Determines if the player can take multiple photos of a single pokemon\n")
    private boolean multiplePhotosOfSamePokemon = true;
    @Comment(value="Whether which battle gimmick can be used is determined purely by band chosen\n")
    private boolean relaxedBattleGimmickRules = true;
    @Comment(value="Volume of the music that is played during battles\n")
    private float battleMusicVolume = 1.0f;
    @Comment(value="Whether or not Pok\u00e9mon can gain experience when battling other players\n")
    private boolean allowPVPExperience = true;
    @Comment(value="Whether or not NPC Trainers' Pok\u00e9mon award experience upon defeat\n")
    private boolean allowTrainerExperience = true;
    @Comment(value="If enabled, consumable held items used up during player vs. player battles will be restored when the battle ends\n")
    private boolean returnHeldItems = true;
    @Comment(value="This setting determines what will occur if a battle is ended without a proper conclusion (e.g., too many errors in battle, player death while in battle).\nDetermining an official winner and loser only matters for certain aspects, such as the /pokestats command,\nNPC Trainers that give items upon defeat, or Pixelmon sidemods that manipulate battle wins and losses.\nThe Different Modes are as Follows:\n  - WINNER - A winner will be chosen based on which battler has more pokemon remaining, of which has the most HP remaining on their team\n  - DRAW - The battle gets declared as a draw\n  - ABNORMAL - The battle is considered to have ended abnormally\n")
    private ForceBattleEndResult forceEndBattleResult = ForceBattleEndResult.WINNER;
    @Comment(value="Multiplier for experience gained in Pok\u00e9mon battles\n")
    private float expModifier = 1.0f;
    @Comment(value="\t\t\tChance for Synchronize to sync nature on battle start. (1 is 100% chance, 0.5 is 50% chance)\n")
    private float synchronizeChance = 1.0f;
    @Comment(value="Whether Happy Hour will award Pok\u00e9Dollars when used\n")
    private boolean allowHappyHour = true;
    @Comment(value="The multiplier for how many Pok\u00e9Dollars will be awarded by using Happy Hour (2.0 = 2x Multiplier)\n")
    private int happyHourMultiplier = 2;
    @Comment(value="Whether Pay Day will award extra Pok\u00e9Dollars when used\n")
    private boolean allowPayDay = true;
    @Comment(value="The multiplier for how many Pok\u00e9Dollars will be awarded by using Pay Day (5.0 = 5x Multiplier)\n")
    private double payDayMultiplier = 5.0;
    @Comment(value="If G-Max Gold Rush will award extra Pok\u00e9Dollars when used.\n")
    private boolean allowGMaxGoldRush = true;
    @Comment(value="The multiplier for how many Pok\u00e9Dollars will be awarded by using G-Max Gold Rush\n")
    private double gMaxGoldRushMultiplier = 100.0;
    @Comment(value="Whether Amulet Coin will award double Pok\u00e9Dollars when used.\n")
    private boolean allowAmuletCoin = true;
    @Comment(value="The multiplier for how many Pok\u00e9Dollars will be awarded by using Amulet Coin (2.0 = 2x Multiplier)\n")
    private int amuletCoinMultiplier = 2;
    @Comment(value="The rate (1/x) that Pickup will collect special drops at. 0 disables this.\n")
    private int pickupRate = 10;
    @Comment(value="Allows chaining catches to get bonus exp, higher shiny and perfect iv rates. If false, all captures use the first threshold listed.\n")
    private boolean allowCatchCombo = true;
    @Comment(value="Catch Combos count thresholds at which the effects of the combo change. Default values give the combo ranges 0, 1-10, 11-20, 21-30, 31-40, and 41+.\n")
    private List<Integer> catchComboThresholds = Lists.newArrayList((Object[])new Integer[]{0, 10, 20, 30, 40});
    @Comment(value="Catch Combos exp bonuses per threshold.\n")
    private List<Float> catchComboExpBonuses = Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.5f), Float.valueOf(2.0f), Float.valueOf(2.5f), Float.valueOf(3.0f)});
    @Comment(value="Catch Combos shiny modifiers per threshold.\n")
    private List<Float> catchComboShinyModifiers = Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.4f), Float.valueOf(1.8f), Float.valueOf(2.2f), Float.valueOf(2.2f)});
    @Comment(value="Catch Combos perfect IVs per threshold.\n")
    private List<Integer> catchComboPerfectIVs = Lists.newArrayList((Object[])new Integer[]{0, 0, 2, 3, 4, 4});
    @Comment(value="Whether or not the levels Pok\u00e9mon found in Pixelmon grass will scale to the level of the player's highest-leveled Pok\u00e9mon.\n")
    private boolean scaleGrassBattles = false;
    @Comment(value="Whether a battle with a wild Pok\u00e9mon should start with its weather reflecting the weather of Minecraft's Overworld.\n")
    private boolean overworldWeatherAffectsWildBattleWeather = true;
    @Comment(value="Whether a battle with a NPC Trainer should start with its weather reflecting the weather of Minecraft's Overworld.\n")
    private boolean overworldWeatherAffectsTrainerBattleWeather = true;
    @Comment(value="Whether a PvP battle should start with its weather reflecting the weather of Minecraft's Overworld.\n")
    private boolean overworldWeatherAffectsPvPBattleWeather = false;
    @Comment(value="Whether a raid battle should start with its weather reflecting the weather of Minecraft's Overworld.\n")
    private boolean overworldWeatherAffectsRaidBattleWeather = false;
    @Comment(value="Whether Minecraft's weather in the Overworld should change battle weather during the battle,\nnot just at the beginning of the battle.\nThis shouldn't change battle weather that is created by players via an ability or move.\n")
    private boolean overworldWeatherCanChangeBattleWeatherDuringBattle = true;

    public BattleAIMode getBattleAIWild() {
        return this.battleAIWild;
    }

    public BattleAIMode getBattleAIBoss() {
        return this.battleAIBoss;
    }

    public BattleAIMode getBattleAITrainer() {
        return this.battleAITrainer;
    }

    public boolean isRelaxedBattleGimmickRules() {
        return this.relaxedBattleGimmickRules;
    }

    public float getBattleMusicVolume() {
        return this.battleMusicVolume;
    }

    public boolean isAllowPVPExperience() {
        return this.allowPVPExperience;
    }

    public boolean isAllowTrainerExperience() {
        return this.allowTrainerExperience;
    }

    public boolean isReturnHeldItems() {
        return this.returnHeldItems;
    }

    public ForceBattleEndResult getForceEndBattleResult() {
        return this.forceEndBattleResult;
    }

    public float getExpModifier() {
        return this.expModifier;
    }

    public float getSynchronizeChance() {
        return this.synchronizeChance;
    }

    public boolean isAllowHappyHour() {
        return this.allowHappyHour;
    }

    public int getHappyHourMultiplier() {
        return this.happyHourMultiplier;
    }

    public boolean isAllowPayDay() {
        return this.allowPayDay;
    }

    public double getPayDayMultiplier() {
        return this.payDayMultiplier;
    }

    public boolean isAllowGMaxGoldRush() {
        return this.allowGMaxGoldRush;
    }

    public double getgMaxGoldRushMultiplier() {
        return this.gMaxGoldRushMultiplier;
    }

    public int getPickupRate() {
        return this.pickupRate;
    }

    public boolean isAllowCatchCombo() {
        return this.allowCatchCombo;
    }

    public List<Integer> getCatchComboThresholds() {
        return this.catchComboThresholds;
    }

    public List<Float> getCatchComboExpBonuses() {
        return this.catchComboExpBonuses;
    }

    public List<Float> getCatchComboShinyModifiers() {
        return this.catchComboShinyModifiers;
    }

    public List<Integer> getCatchComboPerfectIVs() {
        return this.catchComboPerfectIVs;
    }

    public boolean isScaleGrassBattles() {
        return this.scaleGrassBattles;
    }

    public boolean isOverworldWeatherAffectsWildBattleWeather() {
        return this.overworldWeatherAffectsWildBattleWeather;
    }

    public boolean isOverworldWeatherAffectsTrainerBattleWeather() {
        return this.overworldWeatherAffectsTrainerBattleWeather;
    }

    public boolean isOverworldWeatherAffectsPvPBattleWeather() {
        return this.overworldWeatherAffectsPvPBattleWeather;
    }

    public boolean isOverworldWeatherAffectsRaidBattleWeather() {
        return this.overworldWeatherAffectsRaidBattleWeather;
    }

    public boolean isOverworldWeatherCanChangeBattleWeatherDuringBattle() {
        return this.overworldWeatherCanChangeBattleWeatherDuringBattle;
    }
}

