/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;

public abstract class WikiCommandStrategy {
    protected final Set<String> ids;

    public WikiCommandStrategy(String ... ids) {
        this(new HashSet<String>(Arrays.asList(ids)));
    }

    public WikiCommandStrategy(Set<String> ids) {
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'ids' can't be empty!");
        }
        this.ids = ids;
    }

    public abstract void execute(CommandSourceStack var1, Pokemon var2, String[] var3);

    public Optional<Component> getBanner(CommandSourceStack sender, Pokemon pokemon, String[] args) {
        String id = this.ids.iterator().next();
        String newCmd = "/wiki " + String.join((CharSequence)" ", args) + " " + id;
        return Optional.of(PixelmonCommandUtils.format("pixelmon.command.wiki." + id + ".banner", new Object[0]).m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"pixelmon.command.wiki.banner.hover"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, newCmd))));
    }

    public boolean matches(String strategyId) {
        return this.ids.contains(strategyId);
    }

    public int getPriority() {
        return 10;
    }
}

