/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.PixelmonPlayerUtils;
import com.pixelmonmod.pixelmon.api.util.ThreadPool;
import com.pixelmonmod.pixelmon.api.util.helpers.PlayerHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PixelmonCommandUtils {
    public static final ThreadPool THREAD_POOL = ThreadPool.createNewThreadPool("Pixelmon Commands", 2);
    public static final List<String> PARTY_SLOTS = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    public static final List<String> SPEC_REQUIREMENTS = Lists.newArrayList((Object[])PokemonSpecificationProxy.getRequirementNames());
    public static final List<String> REMOVE_ARGUMENT = Lists.newArrayList((Object[])new String[]{"remove"});
    public static final List<String> TARGET_SELECTORS = Lists.newArrayList((Object[])new String[]{"@p", "@r", "@a", "@e", "@s"});

    public static void notifyCommandListener(CommandSourceStack sender, PixelCommand command, int i, String translatedText, Object ... values) {
        sender.m_288197_(() -> Component.m_237110_((String)translatedText, (Object[])values), true);
    }

    public static String[] setupCommandTargets(PixelCommand command, CommandSourceStack sender, String[] args, int playerIndex) throws CommandRuntimeException, CommandSyntaxException {
        String selector;
        if (args.length > playerIndex && (selector = args[playerIndex]).startsWith("@")) {
            List playerMatches = PixelmonCommandUtils.getEntitySelector(selector).m_121160_(sender);
            PixelmonCommandUtils.require(playerMatches, "argument.entity.notfound.player", selector);
            if (!playerMatches.isEmpty()) {
                Entity first = (Entity)playerMatches.remove(0);
                for (Entity entity : playerMatches) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    String[] newArgs = (String[])args.clone();
                    newArgs[playerIndex] = entity.m_7755_().getString();
                    command.execute(sender, newArgs);
                }
                args[playerIndex] = first.m_7755_().getString();
                return args;
            }
        }
        return command.setupTargetOrSourceAsTarget(sender, args, playerIndex);
    }

    public static EntitySelector getEntitySelector(String username) throws CommandSyntaxException {
        return new EntitySelectorParser(new StringReader(username), true).m_121377_();
    }

    @Nonnull
    public static ServerPlayer requireEntityPlayer(String username) throws CommandRuntimeException {
        ServerPlayer player = PixelmonCommandUtils.getEntityPlayer(username);
        if (player != null) {
            return player;
        }
        throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, "argument.entity.notfound.player", username));
    }

    public static ServerPlayer requireEntityPlayer(CommandSourceStack source) throws CommandRuntimeException {
        try {
            return source.m_81375_();
        }
        catch (CommandSyntaxException e) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, "argument.entity.notfound.player", source.m_81368_()));
        }
    }

    @Nullable
    public static ServerPlayer getEntityPlayer(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        if (username.length() == 36) {
            return PixelmonCommandUtils.getEntityPlayer(UUID.fromString(username));
        }
        if (username.length() == 32) {
            BigInteger bigInteger = new BigInteger(username, 16);
            UUID uuid = new UUID(bigInteger.shiftRight(64).longValue(), bigInteger.longValue());
            return PixelmonCommandUtils.getEntityPlayer(uuid);
        }
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (!player.m_7755_().getString().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    public static ServerPlayer getEntityPlayer(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
    }

    public static GameProfile findProfile(String username) {
        if (username == null || username.isEmpty()) {
            return null;
        }
        ServerPlayer playerMP = PixelmonCommandUtils.getEntityPlayer(username);
        if (playerMP != null) {
            return playerMP.m_36316_();
        }
        GameProfileCache cache = ServerLifecycleHooks.getCurrentServer().m_129927_();
        if (username.length() == 36) {
            UUID uuid = UUID.fromString(username);
            return cache.m_11002_(uuid).orElse(null);
        }
        if (username.length() == 32) {
            BigInteger bigInteger = new BigInteger(username, 16);
            UUID uuid = new UUID(bigInteger.shiftRight(64).longValue(), bigInteger.longValue());
            return cache.m_11002_(uuid).orElse(null);
        }
        return PixelmonPlayerUtils.getGameProfileNoLookup(cache, username);
    }

    public static int requireInt(String input, String message) throws CommandRuntimeException {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException var2) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, message, input));
        }
    }

    public static int requireInt(String input, int min, int max, String message, Object ... data) throws CommandRuntimeException {
        try {
            int i = Integer.parseInt(input);
            if (i < min) {
                throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, "argument.integer.low", min, input));
            }
            if (i > max) {
                throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, "argument.integer.big", max, input));
            }
            return i;
        }
        catch (NumberFormatException var2) {
            throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, message, input, data));
        }
    }

    public static void require(boolean boo, String message, Object ... data) throws CommandRuntimeException {
        if (!boo) {
            PixelmonCommandUtils.endCommand(message, data);
        }
    }

    @Nonnull
    public static <T> T require(Optional<T> optional, String message, Object ... data) throws CommandRuntimeException {
        if (!optional.isPresent()) {
            PixelmonCommandUtils.endCommand(message, data);
        }
        return optional.get();
    }

    @Nonnull
    public static <T> T require(T obj, String message, Object ... data) throws CommandRuntimeException {
        if (obj == null) {
            PixelmonCommandUtils.endCommand(message, data);
        } else if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            PixelmonCommandUtils.endCommand(message, data);
        } else if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            PixelmonCommandUtils.endCommand(message, data);
        }
        return obj;
    }

    public static void endCommand(String message, Object ... data) throws CommandRuntimeException {
        throw PixelmonCommandUtils.getException(PixelmonCommandUtils.format(ChatFormatting.RED, message, data));
    }

    public static CommandRuntimeException getException(String translation, Object ... data) {
        return PixelmonCommandUtils.getException(Component.m_237110_((String)translation, (Object[])data));
    }

    public static CommandRuntimeException getException(MutableComponent translation) {
        return new FilledInStackTrace((Component)translation);
    }

    @Nullable
    public static PlayerPartyStorage getPlayerStorage(ServerPlayer player) {
        return StorageProxy.getPartyNow(player);
    }

    public static PCStorage getComputerStorage(ServerPlayer player) {
        return StorageProxy.getPCForPlayerNow(player);
    }

    public static List<String> tabCompleteUsernames() {
        return Lists.newArrayList((Object[])ServerLifecycleHooks.getCurrentServer().m_7641_());
    }

    public static List<String> tabCompletePokemon() {
        return Lists.newArrayList(PixelmonSpecies.getFormattedEnglishNameSet());
    }

    public static List<String> tabCompleteWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ArrayList worlds = Lists.newArrayList();
        for (ResourceKey key : server.m_129784_()) {
            worlds.add(key.m_135782_().toString());
        }
        return worlds;
    }

    public static ServerLevel getWorld(String[] args, CommandSourceStack sender) {
        if (args.length < 1) {
            return sender.m_81372_();
        }
        ServerLevel world = sender.m_81377_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocationHelper.of(args[0])));
        if (world == null) {
            return sender.m_81372_();
        }
        return world;
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public static MutableComponent format(ChatFormatting color, String lang, Object ... args) {
        return PixelmonCommandUtils.format(TextColor.m_131270_((ChatFormatting)color), lang, args);
    }

    public static MutableComponent format(ChatFormatting color, String lang, Consumer<MutableComponent> formatting, Object ... args) {
        MutableComponent textComponent = PixelmonCommandUtils.format(TextColor.m_131270_((ChatFormatting)color), lang, args);
        formatting.accept(textComponent);
        return textComponent;
    }

    public static MutableComponent format(TextColor color, String lang, Object ... args) {
        MutableComponent message = Component.m_237110_((String)lang, (Object[])args);
        message.m_6270_(message.m_7383_().m_131148_(color));
        return message;
    }

    public static MutableComponent format(String lang, Object ... args) {
        return PixelmonCommandUtils.format(ChatFormatting.GRAY, lang, args);
    }

    public static void sendMessage(ServerPlayer target, ChatFormatting color, String string, Object ... data) {
        target.m_213846_((Component)PixelmonCommandUtils.format(color, string, data));
    }

    public static void sendMessage(CommandSourceStack sender, ChatFormatting color, String string, Object ... data) {
        sender.m_288197_(() -> PixelmonCommandUtils.format(color, string, data), false);
    }

    public static void sendMessage(CommandSourceStack sender, ChatFormatting color, String string, Consumer<MutableComponent> formatting, Object ... data) {
        sender.m_288197_(() -> PixelmonCommandUtils.format(color, string, formatting, data), false);
    }

    public static void sendMessage(CommandSourceStack sender, String string, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GRAY, string, data);
    }

    public static void sendMessage(CommandSourceStack sender, String string, Consumer<MutableComponent> formatting, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GRAY, string, formatting, data);
    }

    public static void sendMessage(ServerPlayer sender, String string, Object ... data) {
        PixelmonCommandUtils.sendMessage(sender, ChatFormatting.GRAY, string, data);
    }

    public static boolean hasPermission(CommandSourceStack source, String permission) {
        try {
            ServerPlayer ServerPlayer2 = source.m_81375_();
            return PlayerHelper.hasPermission(ServerPlayer2, permission);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    public static void applySpecs(Pokemon pokemon, String[] specList) throws CommandRuntimeException {
        ParseAttempt<PokemonSpecification> parseAttempt = PokemonSpecificationProxy.create(specList);
        if (!parseAttempt.wasSuccess()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.general.invalid", parseAttempt.getError());
        }
        PokemonSpecification spec = parseAttempt.get();
        spec.apply(pokemon);
    }

    private static class FilledInStackTrace
    extends CommandRuntimeException {
        public FilledInStackTrace(Component message) {
            super(message);
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

