/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.items.ItemData;
import com.pixelmonmod.pixelmon.items.PokeBagItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class BattleItemScanner {
    private static final List<InventoryScanner> SCANNERS = Lists.newArrayList();

    private BattleItemScanner() {
        throw new IllegalStateException("Cannot instantiate this class");
    }

    public static void addScanner(InventoryScanner scanner) {
        SCANNERS.add(scanner);
    }

    public static List<ItemData> scan(ServerPlayer player, BagSection section) {
        ArrayList itemData = Lists.newArrayList();
        BattleItemScanner.checkInventory(player, section, (Container)player.m_150109_(), (List<ItemData>)itemData);
        return itemData;
    }

    public static void checkInventory(ServerPlayer player, BagSection section, Container inventory, List<ItemData> items) {
        BattleItemScanner.checkInventory(player, section, com.pixelmonmod.pixelmon.api.util.helpers.ContainerHelper.getAllItems(inventory), items);
    }

    public static void checkInventory(ServerPlayer player, BagSection section, List<ItemStack> inventory, List<ItemData> items) {
        BattleItemScanner.checkInventory(player, section, inventory, true, items);
    }

    public static void checkInventory(ServerPlayer player, BagSection section, List<ItemStack> inventory, boolean checkSubInventories, List<ItemData> items) {
        for (ItemStack stack : inventory) {
            if (stack == null || stack.m_41619_()) continue;
            boolean matched = false;
            if (checkSubInventories) {
                for (InventoryScanner scanner : SCANNERS) {
                    if (!scanner.testItem(stack)) continue;
                    matched = true;
                    scanner.collectItems(player, section, inventory, stack, items);
                    break;
                }
            }
            if (matched) continue;
            BattleItemScanner.addItem(section, stack, items);
        }
    }

    public static void addItem(BagSection section, ItemStack stack, List<ItemData> items) {
        if (!section.isItem(stack)) {
            return;
        }
        if (!BattleItemScanner.attemptUpdate(stack, items)) {
            items.add(new ItemData(stack.m_41777_()));
        }
    }

    public static boolean attemptUpdate(ItemStack stack, List<ItemData> items) {
        for (ItemData itemDatum : items) {
            if (!ItemStack.m_150942_((ItemStack)itemDatum.getItemStack(), (ItemStack)stack)) continue;
            itemDatum.getItemStack().m_41764_(itemDatum.getItemStack().m_41613_() + stack.m_41613_());
            return true;
        }
        return false;
    }

    public static ItemStack findMatchingItem(ItemStack toMatch, ServerPlayer player) {
        return BattleItemScanner.findMatchingItem(toMatch, player, (Container)player.m_150109_());
    }

    public static ItemStack findMatchingItem(ItemStack toMatch, ServerPlayer player, Container inventory) {
        ItemStack playerInventoryCheck = BattleItemScanner.findItemFromIterable(toMatch, inventory.m_6643_(), arg_0 -> ((Container)inventory).m_8020_(arg_0));
        if (playerInventoryCheck != null) {
            return playerInventoryCheck;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryItem = inventory.m_8020_(i);
            ItemStack foundItem = null;
            for (InventoryScanner scanner : SCANNERS) {
                if (scanner.testItem(inventoryItem) && (foundItem = scanner.findItem(player, inventoryItem, toMatch)) != null) break;
            }
            if (foundItem == null) continue;
            return foundItem;
        }
        return null;
    }

    public static ItemStack findItemFromIterable(ItemStack toMatch, int size, IntFunction<ItemStack> getter) {
        for (int i = 0; i < size; ++i) {
            ItemStack stack = getter.apply(i);
            if (!ItemStack.m_150942_((ItemStack)toMatch, (ItemStack)stack)) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack consumeItem(ItemStack toMatch, ServerPlayer player) {
        return BattleItemScanner.consumeItem(toMatch, player, (Container)player.m_150109_());
    }

    public static ItemStack consumeItem(ItemStack toMatch, ServerPlayer player, Container inventory) {
        int i;
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)toMatch)) continue;
            inventory.m_7407_(i, 1);
            return itemStack;
        }
        for (i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryItem = inventory.m_8020_(i);
            ItemStack consumedItem = null;
            for (InventoryScanner scanner : SCANNERS) {
                if (scanner.testItem(inventoryItem) && (consumedItem = scanner.consumeItem(player, inventoryItem, toMatch)) != null) break;
            }
            if (consumedItem == null) continue;
            return consumedItem;
        }
        return null;
    }

    static {
        BattleItemScanner.addScanner(new InventoryScanner(stack -> stack.m_41720_() instanceof PokeBagItem, (player, section, inventory, stack, items) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((Player)player, stack);
            if (pokeBag != null) {
                BattleItemScanner.checkInventory(player, section, pokeBag.inventory, (List<ItemData>)items);
            }
        }, (player, inventory, toMatch) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((Player)player, inventory);
            if (pokeBag == null) {
                return null;
            }
            return BattleItemScanner.findItemFromIterable(toMatch, pokeBag.inventory.m_6643_(), i -> pokeBag.inventory.m_8020_(i));
        }, (player, inventory, toMatch) -> {
            PokeBagItem.PokeBag pokeBag = PokeBagItem.PokeBag.readFromItemStack((Player)player, inventory);
            if (pokeBag == null) {
                return null;
            }
            for (int i = 0; i < pokeBag.inventory.m_6643_(); ++i) {
                ItemStack slot = pokeBag.inventory.m_8020_(i);
                if (!ItemStack.m_41656_((ItemStack)slot, (ItemStack)toMatch) || !ItemStack.m_150942_((ItemStack)slot, (ItemStack)toMatch)) continue;
                pokeBag.inventory.m_7407_(i, 1);
                pokeBag.writeToStack(inventory);
                return slot;
            }
            return null;
        }));
        BattleItemScanner.addScanner(new InventoryScanner(stack -> Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock, (player, section, inventory, stack, items) -> {
            CompoundTag CompoundTag2 = stack.m_41737_("BlockEntityTag");
            if (CompoundTag2 != null && CompoundTag2.m_128441_("Items")) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)CompoundTag2, (NonNullList)nonnulllist);
                BattleItemScanner.checkInventory(player, section, (List<ItemStack>)nonnulllist, false, items);
            }
        }, (player, inventory, toMatch) -> {
            CompoundTag CompoundTag2 = inventory.m_41737_("BlockEntityTag");
            if (CompoundTag2 == null || !CompoundTag2.m_128441_("Items")) {
                return null;
            }
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)CompoundTag2, (NonNullList)nonnulllist);
            return BattleItemScanner.findItemFromIterable(toMatch, nonnulllist.size(), arg_0 -> ((NonNullList)nonnulllist).get(arg_0));
        }, (player, inventory, toMatch) -> {
            CompoundTag CompoundTag2 = inventory.m_41737_("BlockEntityTag");
            if (CompoundTag2 == null || !CompoundTag2.m_128441_("Items")) {
                return null;
            }
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)CompoundTag2, (NonNullList)nonnulllist);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack stack = (ItemStack)nonnulllist.get(i);
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)toMatch) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)toMatch)) continue;
                ContainerHelper.m_18969_((List)nonnulllist, (int)i, (int)1);
                ContainerHelper.m_18973_((CompoundTag)CompoundTag2, (NonNullList)nonnulllist);
                return stack;
            }
            return null;
        }));
    }

    public static class InventoryScanner {
        private final Predicate<ItemStack> predicate;
        private final ItemScanner scanner;
        private final ItemFinder finder;
        private final ItemConsumer consumer;

        public InventoryScanner(Predicate<ItemStack> predicate, ItemScanner scanner, ItemFinder finder, ItemConsumer consumer) {
            this.predicate = predicate;
            this.scanner = scanner;
            this.finder = finder;
            this.consumer = consumer;
        }

        protected boolean testItem(ItemStack stack) {
            return stack != null && this.predicate.test(stack);
        }

        protected void collectItems(ServerPlayer player, BagSection section, List<ItemStack> inventory, ItemStack stack, List<ItemData> items) {
            this.scanner.scan(player, section, inventory, stack, items);
        }

        protected ItemStack findItem(ServerPlayer player, ItemStack inventory, ItemStack toMatch) {
            return this.finder.find(player, inventory, toMatch);
        }

        protected ItemStack consumeItem(ServerPlayer player, ItemStack inventory, ItemStack toMatch) {
            return this.consumer.consume(player, inventory, toMatch);
        }
    }

    @FunctionalInterface
    public static interface ItemScanner {
        public void scan(ServerPlayer var1, BagSection var2, List<ItemStack> var3, ItemStack var4, List<ItemData> var5);
    }

    @FunctionalInterface
    public static interface ItemFinder {
        public ItemStack find(ServerPlayer var1, ItemStack var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface ItemConsumer {
        public ItemStack consume(ServerPlayer var1, ItemStack var2, ItemStack var3);
    }
}

