/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.battles;

import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.items.BattleItem;
import com.pixelmonmod.pixelmon.items.PPRestoreItem;
import com.pixelmonmod.pixelmon.items.PokeBallItem;
import com.pixelmonmod.pixelmon.items.StatusAilmentHealerItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryGinemaItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryJuiceItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryLeppaItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryRestoreHPItem;
import com.pixelmonmod.pixelmon.items.heldItems.BerryStatusItem;
import com.pixelmonmod.pixelmon.items.heldItems.MentalHerbItem;
import com.pixelmonmod.pixelmon.items.heldItems.MirrorHerbItem;
import com.pixelmonmod.pixelmon.items.heldItems.WhiteHerbItem;
import com.pixelmonmod.pixelmon.items.medicine.MedicineItem;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum BagSection implements ITranslatable
{
    POKEBALLS("gui.choosebag.pokeballs", itemStack -> itemStack.m_41720_() instanceof PokeBallItem),
    HP("gui.choosebag.hppp", itemStack -> {
        Item item = itemStack.m_41720_();
        return item instanceof MedicineItem || item instanceof BerryRestoreHPItem || item instanceof BerryJuiceItem || item instanceof PPRestoreItem || item instanceof BerryLeppaItem;
    }),
    BATTLE_ITEMS("gui.choosebag.battleitems", itemStack -> {
        Item item = itemStack.m_41720_();
        return item instanceof BattleItem;
    }),
    STATUS_RESTORE("gui.choosebag.statusrestore", itemStack -> {
        Item item = itemStack.m_41720_();
        return item instanceof StatusAilmentHealerItem || item == PixelmonItems.full_restore || item instanceof BerryStatusItem || item instanceof MentalHerbItem || item instanceof BerryGinemaItem || item instanceof WhiteHerbItem || item instanceof MirrorHerbItem;
    });

    private final String translationKey;
    private final Predicate<ItemStack> fits;

    private BagSection(String translationKey, Predicate<ItemStack> fits) {
        this.translationKey = translationKey;
        this.fits = fits;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        return this.fits.test(itemStack);
    }

    public static BagSection getSection(int index) {
        try {
            return BagSection.values()[index];
        }
        catch (Exception npe) {
            return null;
        }
    }

    public static boolean hasBag(String name) {
        try {
            BagSection.valueOf(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

