/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.attackAnimations;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayBattleParticleSystemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class VariableParticleEffect {
    public Level dimension;
    public AttackAnimationData effectData;
    public int startEntityID = -1;
    public Vec3 startPos = new Vec3(0.0, 0.0, 0.0);
    public int endEntityID = -1;
    public Vec3 endPos = new Vec3(0.0, 0.0, 0.0);
    public ImmutableAttack immutableAttack = AttackRegistry.getAttackBaseFromEnglishName("Tackle").get();

    public VariableParticleEffect(Level dimension, AttackAnimationData effectData) {
        this.dimension = dimension;
        this.effectData = effectData;
    }

    public VariableParticleEffect setStartPosition(LivingEntity entity) {
        this.startEntityID = entity.m_19879_();
        this.startPos = entity.m_20182_().m_82549_(new Vec3(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
        return this;
    }

    public VariableParticleEffect setStartPosition(Vec3 vec) {
        this.startPos = vec;
        return this;
    }

    public VariableParticleEffect setEndPosition(LivingEntity entity) {
        this.endEntityID = entity.m_19879_();
        this.endPos = entity.m_20182_();
        return this;
    }

    public VariableParticleEffect setEndPosition(Vec3 vec) {
        this.endPos = vec;
        return this;
    }

    public VariableParticleEffect setAttackBase(ImmutableAttack immutableAttack) {
        this.immutableAttack = immutableAttack;
        return this;
    }

    private PlayBattleParticleSystemPacket makePacket() {
        return new PlayBattleParticleSystemPacket(this.dimension, this.effectData, this.immutableAttack, this.startEntityID, this.startPos, this.endEntityID, this.endPos);
    }

    public void showTo(ServerPlayer ... players) {
        PlayBattleParticleSystemPacket packet = this.makePacket();
        for (ServerPlayer player : players) {
            NetworkHelper.sendPacket(player, packet);
        }
    }

    public void showAllWithin(int range) {
        Vec3 use = this.startPos == Vec3.f_82478_ ? this.endPos : this.startPos;
        PlayBattleParticleSystemPacket packet = this.makePacket();
        NetworkHelper.sendNearbyPacket(new PacketDistributor.TargetPoint(use.f_82479_, use.f_82480_, use.f_82481_, (double)range, this.dimension.m_46472_()), packet);
    }
}

