/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.attackAnimations;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayBattleParticleSystemPacket;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public abstract class AttackAnimation {
    public transient BattleController bc;
    public transient int ticks = -1;
    public transient ResourceKey<Level> dimension = null;
    public transient int startID;
    public transient PixelmonWrapper user;
    public transient float[] userPos;
    public transient int endID;
    public transient PixelmonWrapper target;
    public transient float[] targetPos;
    public transient Attack attack;
    public transient Element effectiveType;

    public AttackAnimation instantiate(PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        try {
            AttackAnimation animation = (AttackAnimation)this.getClass().newInstance();
            for (Field f : animation.getClass().getFields()) {
                if (Modifier.isTransient(f.getModifiers())) continue;
                f.set(animation, f.get(this));
            }
            animation.initialize(user, target, attack);
            animation.tickAnimation(++animation.ticks);
            return animation;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initialize(PixelmonWrapper user, PixelmonWrapper target, Attack attack) {
        this.bc = user.bc;
        this.user = user;
        this.target = target;
        this.attack = attack;
        this.effectiveType = attack.getMove().getAttackType();
        if (user.entity == null || target.entity == null) {
            return;
        }
        this.dimension = user.entity.f_19853_.m_46472_();
        this.startID = user.entity.m_19879_();
        this.userPos = new float[]{(float)user.entity.m_20185_(), (float)user.entity.m_20186_(), (float)user.entity.m_20189_()};
        this.endID = target.entity.m_19879_();
        this.targetPos = new float[]{(float)target.entity.m_20185_(), (float)target.entity.m_20186_(), (float)target.entity.m_20189_()};
    }

    public abstract boolean tickAnimation(int var1);

    public abstract boolean usedOncePerTurn();

    public void sendBattleEffect(AttackAnimationData data, boolean groundedStartPosition, boolean groundedEndPosition) {
        if (this.dimension == null) {
            return;
        }
        try {
            PlayBattleParticleSystemPacket packet = new PlayBattleParticleSystemPacket(this, this.attack, data, groundedStartPosition, groundedEndPosition);
            if (PixelmonConfigProxy.getGraphics().isOnlyShowAttackEffectsToBattlers()) {
                this.user.bc.spectators.forEach(spectator -> NetworkHelper.sendPacket(spectator.getEntity(), packet));
                this.user.bc.getPlayers().forEach(pp -> {
                    if (pp.player != null) {
                        NetworkHelper.sendPacket(pp.player, packet);
                    }
                });
            } else {
                ResourceKey dim = this.user.getParticipant().getEntity().f_19853_.m_46472_();
                double x = this.user.getParticipant().getEntity().m_20185_();
                double y = this.user.getParticipant().getEntity().m_20186_();
                double z = this.user.getParticipant().getEntity().m_20189_();
                NetworkHelper.sendNearbyPacket(new PacketDistributor.TargetPoint(x, y, z, (double)PixelmonConfigProxy.getGraphics().getRangeToDisplayAttackAnimations(), dim), packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

