/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class PokedexTrigger
extends SimpleCriterionTrigger<Instance> {
    public Instance createInstance(JsonObject json, Optional<ContextAwarePredicate> contextAwarePredicate, DeserializationContext conditions) {
        float percent = json.has("percent") ? json.get("percent").getAsFloat() : 0.0f;
        return new Instance(contextAwarePredicate, percent);
    }

    public void trigger(ServerPlayer player) {
        this.m_66234_(player, instance -> instance.test(player));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final float percent;

        public Instance(Optional<ContextAwarePredicate> contextAwarePredicate, float percent) {
            super(contextAwarePredicate);
            this.percent = percent;
        }

        public boolean test(ServerPlayer player) {
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
            float caught = storage.playerPokedex.countCaught() > 0 ? (float)(storage.playerPokedex.countCaught() + 1) : 0.0f;
            float totalDex = PixelmonSpecies.getAll().size() - 1;
            return caught / totalDex * 100.0f >= this.percent;
        }
    }
}

