/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.gson.JsonObject;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class LegendaryCaptureTrigger
extends SimpleCriterionTrigger<Instance> {
    public Instance createInstance(JsonObject json, Optional<ContextAwarePredicate> contextAwarePredicate, DeserializationContext conditions) {
        String pokemon = json.has("pokemon") ? json.get("pokemon").getAsString() : "";
        return new Instance(contextAwarePredicate, () -> {
            RegistryValue<Species> species = PixelmonSpecies.fromName(pokemon);
            if (!species.isInitialized()) {
                Pixelmon.LOGGER.error("There was an error in Legendary Advancement trigger: " + pokemon);
                Pixelmon.LOGGER.error(json.toString());
                return null;
            }
            return species.getValueUnsafe();
        }, pokemon);
    }

    public void trigger(ServerPlayer player, Pokemon pokemon) {
        this.m_66234_(player, instance -> instance.test(pokemon));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final String name;
        private final Supplier<Species> pokemon;

        public Instance(Optional<ContextAwarePredicate> contextAwarePredicate, Supplier<Species> pokemon, String name) {
            super(contextAwarePredicate);
            this.name = name;
            this.pokemon = pokemon;
        }

        public boolean test(Pokemon pokemon) {
            if (pokemon == null || !pokemon.isLegendary()) {
                return false;
            }
            if (this.name.equalsIgnoreCase("legendary")) {
                return true;
            }
            Species species = this.pokemon.get();
            return species != null && species.is(pokemon.getSpecies());
        }
    }
}

