/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class CaptureTypeTrigger
extends SimpleCriterionTrigger<Instance> {
    public Instance createInstance(JsonObject json, Optional<ContextAwarePredicate> contextAwarePredicate, DeserializationContext conditions) {
        Element type;
        int count;
        int n = count = json.has("count") ? json.get("count").getAsInt() : 0;
        if (json.has("type")) {
            String value = json.get("type").getAsString();
            type = Element.parseType(value);
        } else {
            type = Element.MYSTERY;
        }
        return new Instance(contextAwarePredicate, count, type);
    }

    public void trigger(ServerPlayer player, Pokemon pokemon, Map<String, Integer> caughtTypeCount) {
        this.m_66234_(player, instance -> instance.test(pokemon, caughtTypeCount));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final int count;
        private final Element type;

        public Instance(Optional<ContextAwarePredicate> contextAwarePredicate, int count, Element type) {
            super(contextAwarePredicate);
            this.count = count;
            this.type = type;
        }

        public boolean test(Pokemon pokemon, Map<String, Integer> caughtTypeCount) {
            if (this.type == Element.MYSTERY) {
                return true;
            }
            int count = caughtTypeCount.get(this.type.getName());
            if (pokemon.getForm().getTypes().contains(this.type)) {
                return this.count <= count;
            }
            return false;
        }
    }
}

