/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai.flying;

import com.pixelmonmod.pixelmon.ai.flying.FlySpeeds;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class BetterFlyingGoal
extends Goal {
    PixelmonEntity pokemon;
    FlySpeeds flyingParameters;
    boolean wantsToFly = true;
    int actionTicks = -1;
    BlockPos target = null;
    float lastYaw;
    BlockPos.MutableBlockPos reusablePos = new BlockPos.MutableBlockPos(0, 0, 0);

    public BetterFlyingGoal(PixelmonEntity pokemon, FlySpeeds flyingParameters) {
        this.pokemon = pokemon;
        this.lastYaw = pokemon.f_19857_;
        this.flyingParameters = flyingParameters;
    }

    public BetterFlyingGoal(PixelmonEntity pokemon) {
        this.pokemon = pokemon;
        this.flyingParameters = new FlySpeeds();
    }

    public void m_8056_() {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        BlockPos pos = this.pokemon.m_20193_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.pokemon.m_20183_());
        if (this.pokemon.m_20183_().m_123342_() - pos.m_123342_() > 10) {
            this.wantsToFly = true;
            this.actionTicks = 1;
            this.m_8036_();
        }
    }

    public boolean m_8036_() {
        --this.actionTicks;
        if (this.wantsToFly) {
            if (this.target == null && this.actionTicks <= 0) {
                this.findAerialTarget();
                if (this.target != null) {
                    this.actionTicks = (int)((double)this.flyingParameters.endurance * (((double)RandomHelper.getRandom().nextFloat() - 0.5) / 5.0));
                    this.moveToTarget();
                }
            } else if (this.target != null) {
                this.moveToTarget();
            }
            if (this.reachedTarget()) {
                this.findAerialTarget();
                if (this.target != null) {
                    this.moveToTarget();
                }
                return true;
            }
            if (this.actionTicks <= 0) {
                this.target = this.findLanding();
                if (this.target != null) {
                    this.wantsToFly = false;
                    this.actionTicks = this.flyingParameters.endurance / 3;
                    this.moveToTarget();
                }
            }
        } else {
            if (this.target != null && this.target.m_123331_((Vec3i)this.pokemon.m_20183_()) > 4.0) {
                this.moveToTarget();
            }
            if (this.actionTicks <= 0) {
                this.wantsToFly = true;
                this.findAerialTarget();
            }
        }
        return false;
    }

    private double findAngle(double x, double z) {
        if (x >= 0.0 && z >= 0.0) {
            return Mth.m_14136_((double)x, (double)z);
        }
        if (x <= 0.0 && z >= 0.0) {
            return Math.PI - Mth.m_14136_((double)x, (double)z);
        }
        if (x <= 0.0 && z <= 0.0) {
            return Math.PI + Mth.m_14136_((double)x, (double)z);
        }
        if (x >= 0.0 && z <= 0.0) {
            return Math.PI * 2 - Mth.m_14136_((double)x, (double)z);
        }
        return 0.0;
    }

    public void moveToTarget() {
        double diffX = (double)this.target.m_123341_() - this.pokemon.m_20182_().f_82479_;
        double diffZ = (double)this.target.m_123343_() - this.pokemon.m_20182_().f_82481_;
        double angleDiff = this.findAngle(diffX, diffZ);
        double angleCurrent = this.findAngle(this.pokemon.m_20184_().f_82479_, this.pokemon.m_20184_().f_82481_);
        double theta = angleDiff - angleCurrent;
        if (angleDiff - angleCurrent > 180.0) {
            theta = -1.0 * (360.0 - theta);
        }
        if (Math.abs(theta) > this.flyingParameters.rotationSpeed) {
            theta = this.flyingParameters.rotationSpeed;
        }
        double motionMagnitude = Math.sqrt(Math.pow(this.pokemon.m_20184_().f_82479_, 2.0) + Math.pow(this.pokemon.m_20184_().f_82481_, 2.0));
        double diffMagnitude = Math.sqrt(Math.pow(diffX, 2.0) + Math.pow(diffZ, 2.0));
        if (this.pokemon.m_20184_().f_82479_ == 0.0 && this.pokemon.m_20184_().f_82481_ == 0.0) {
            this.pokemon.m_20334_(-0.01, this.pokemon.m_20184_().f_82480_, -0.01);
        }
        if ((motionMagnitude += this.flyingParameters.acceleration) > this.flyingParameters.maxFlySpeed) {
            motionMagnitude = this.flyingParameters.maxFlySpeed;
        }
        double desiredMotionX = Math.cos(theta) * this.pokemon.m_20184_().f_82479_ - Math.sin(theta) * this.pokemon.m_20184_().f_82481_;
        double desiredMotionZ = Math.sin(theta) * this.pokemon.m_20184_().f_82479_ + Math.cos(theta) * this.pokemon.m_20184_().f_82481_;
        double newMotionSpeed = Math.sqrt(Math.pow(desiredMotionX, 2.0) + Math.pow(desiredMotionZ, 2.0));
        double ratio = newMotionSpeed / motionMagnitude;
        double yDist = (double)this.target.m_123342_() - this.pokemon.m_20182_().f_82480_;
        this.pokemon.m_20334_(desiredMotionX /= ratio, yDist / diffMagnitude, desiredMotionZ /= ratio);
        float yaw = (float)Math.atan2(-this.pokemon.m_20184_().f_82479_, this.pokemon.m_20184_().f_82481_);
        this.pokemon.f_19857_ = (float)((double)(yaw * 180.0f) / Math.PI);
    }

    public boolean reachedTarget() {
        double dist;
        return this.target != null && (dist = Math.sqrt(Math.pow(this.pokemon.m_20182_().f_82479_ - (double)this.target.m_123341_(), 2.0) + Math.pow(this.pokemon.m_20182_().f_82481_ - (double)this.target.m_123343_(), 2.0))) <= 3.0;
    }

    public boolean findAerialTarget() {
        double baseDir = (double)this.pokemon.f_19857_ + (RandomHelper.getRandom().nextDouble() - 0.5) * 60.0;
        for (int i = 0; i < 3; ++i) {
            int radius = RandomHelper.getRandom().nextInt(30) + 50;
            double direction = baseDir + (double)(i * 60);
            int x = (int)((double)radius * Math.cos(direction * Math.PI / 180.0));
            int z = (int)((double)radius * Math.sin(direction * Math.PI / 180.0));
            this.reusablePos.m_122190_((Vec3i)this.pokemon.m_20193_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)this.reusablePos.m_122178_(x, 1, z)));
            if (this.reusablePos.m_123342_() <= 0 || this.reusablePos.m_123342_() > 230) continue;
            this.target = this.reusablePos.m_7918_(0, 20, 0).m_7949_();
            return true;
        }
        return false;
    }

    public BlockPos findLanding() {
        this.reusablePos.m_122190_((Vec3i)this.pokemon.m_20193_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.pokemon.m_20183_()));
        if (this.reusablePos.m_123342_() > 0) {
            BlockPos pos = this.reusablePos.m_121996_(new Vec3i(0, 1, 0));
            BlockState blockState = this.pokemon.m_20193_().m_8055_(pos);
            if (blockState.m_60815_() && blockState.m_60796_((BlockGetter)this.pokemon.m_20193_(), pos)) {
                return this.reusablePos.m_7949_();
            }
        }
        return null;
    }
}

