/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.levelgen.Heightmap;

public class TeleportAwayGoal
extends Goal {
    PixelmonEntity pixelmon;

    public TeleportAwayGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
    }

    public boolean m_8036_() {
        return !this.pixelmon.hasOwner() && this.pixelmon.f_19853_.m_45930_((Entity)this.pixelmon, 7.0) != null;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        TeleportAwayGoal.teleportRandomly(this.pixelmon, RandomHelper.getRandom());
    }

    public static boolean teleportRandomly(PixelmonEntity pixelmon, Random rand) {
        return TeleportAwayGoal.teleportTo(pixelmon, rand, pixelmon.m_20185_() + (rand.nextDouble() - 0.5) * 64.0, 256.0, pixelmon.m_20189_() + (rand.nextDouble() - 0.5) * 64.0);
    }

    protected static boolean teleportTo(PixelmonEntity pixelmon, Random rand, double suggestedXPos, double suggestedYPos, double suggestedZPos) {
        double currentXPos = pixelmon.m_20185_();
        double currentYPos = pixelmon.m_20186_();
        double currentZPos = pixelmon.m_20189_();
        int intPosX = Mth.m_14107_((double)suggestedXPos);
        int intPosY = Mth.m_14107_((double)suggestedYPos);
        int intPosZ = Mth.m_14107_((double)suggestedZPos);
        BlockPos newLocation = pixelmon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(intPosX, intPosY, intPosZ));
        intPosY = newLocation.m_123342_();
        if (pixelmon.f_19853_.isAreaLoaded(newLocation, 1)) {
            pixelmon.m_6034_(intPosX, intPosY, intPosZ);
            pixelmon.m_6034_(pixelmon.m_20185_(), pixelmon.m_20186_(), pixelmon.m_20189_());
            TeleportAwayGoal.createEndermanEffect(pixelmon, rand, currentXPos, currentYPos, currentZPos);
            if (!pixelmon.f_19853_.m_45784_((Entity)pixelmon) || pixelmon.f_19853_.m_46855_(pixelmon.m_20191_())) {
                return false;
            }
        }
        return true;
    }

    private static void createEndermanEffect(PixelmonEntity pixelmon, Random rand, double currentXPos, double currentYPos, double currentZPos) {
        int baseArea = 128;
        for (int variance = 0; variance < baseArea; ++variance) {
            double bounding = (double)variance / ((double)baseArea - 1.0);
            float floatRandX = (rand.nextFloat() - 0.5f) * 0.2f;
            float floatRandY = (rand.nextFloat() - 0.5f) * 0.2f;
            float floatRandZ = (rand.nextFloat() - 0.5f) * 0.2f;
            double doubleRandX = currentXPos + (pixelmon.m_20185_() - currentXPos) * bounding + (rand.nextDouble() - 0.5) * (double)pixelmon.m_20205_() * 2.0;
            double doubleRandY = currentYPos + (pixelmon.m_20186_() - currentYPos) * bounding + rand.nextDouble() * (double)pixelmon.m_20206_();
            double doubleRandZ = currentZPos + (pixelmon.m_20189_() - currentZPos) * bounding + (rand.nextDouble() - 0.5) * pixelmon.getForm().getDimensions().getLength() * 2.0;
            pixelmon.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, doubleRandX, doubleRandY, doubleRandZ, (double)floatRandX, (double)floatRandY, (double)floatRandZ);
        }
        pixelmon.f_19853_.m_6263_(null, currentXPos, currentYPos, currentZPos, SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

