/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.AggressionEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.listener.RepelHandler;
import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.Event;

public abstract class TargetGoal
extends Goal {
    protected Mob taskOwner;
    protected float targetDistance;
    protected boolean shouldCheckSight;
    private boolean mustReach;
    private int reachCache = 0;
    private int reachCacheTime = 0;
    private int unseenTicks = 0;

    public TargetGoal(PixelmonEntity par1EntityLiving, float targetDistance, boolean shouldCheckSight) {
        this((Mob)par1EntityLiving, targetDistance, shouldCheckSight, false);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public TargetGoal(Mob entity, float targetDistance, boolean shouldCheckSight, boolean mustReach) {
        this.taskOwner = entity;
        this.targetDistance = targetDistance;
        this.shouldCheckSight = shouldCheckSight;
        this.mustReach = mustReach;
    }

    public boolean m_8045_() {
        LivingEntity target;
        if (this.taskOwner instanceof PixelmonEntity) {
            PixelmonEntity pokemon = (PixelmonEntity)this.taskOwner;
            if (pokemon.battleController != null || pokemon.getBossTier().isBoss()) {
                return false;
            }
        } else if (((NPCTrainer)this.taskOwner).battleController != null) {
            return false;
        }
        if ((target = this.taskOwner.m_5448_()) instanceof ServerPlayer) {
            if (((Player)target).m_7500_() || target.m_5833_()) {
                return false;
            }
            return EvolutionQueryList.get((Player)((ServerPlayer)target)) == null;
        }
        if (target == null || !target.m_6084_() || this.taskOwner.m_20280_((Entity)target) > (double)(this.targetDistance * this.targetDistance)) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.taskOwner instanceof NPCTrainer) {
                if (this.taskOwner.m_21574_().m_148306_((Entity)target) && this.checkAngle(target)) {
                    this.unseenTicks = 0;
                } else if (++this.unseenTicks > 60) {
                    return false;
                }
            } else if (this.taskOwner.m_21574_().m_148306_((Entity)target)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > 60) {
                return false;
            }
        }
        return true;
    }

    private boolean checkAngle(LivingEntity var1) {
        double B;
        Vec3 look = this.taskOwner.m_20252_(1.0f);
        Vec3 toTarget = new Vec3(this.taskOwner.m_20185_() - var1.m_20185_(), this.taskOwner.m_20186_() - var1.m_20186_(), this.taskOwner.m_20189_() - var1.m_20189_());
        double top = look.f_82479_ * toTarget.f_82479_ + look.f_82480_ * toTarget.f_82480_ + look.f_82481_ * toTarget.f_82481_;
        double A = Math.sqrt(Math.pow(look.f_82479_, 2.0) + Math.pow(look.f_82480_, 2.0) + Math.pow(look.f_82481_, 2.0));
        double angle = Math.acos(top / (A * (B = Math.sqrt(Math.pow(toTarget.f_82479_, 2.0) + Math.pow(toTarget.f_82480_, 2.0) + Math.pow(toTarget.f_82481_, 2.0)))));
        return Math.abs(angle - Math.PI) <= 0.2;
    }

    public void m_8056_() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    public void m_8041_() {
        this.taskOwner.m_6710_(null);
    }

    public void m_8037_() {
        if (this.taskOwner.m_5448_() instanceof Player && this.taskOwner.m_5448_().m_21023_((MobEffect)EffectRegistration.AVOIDANCE.get())) {
            this.m_8041_();
        }
    }

    protected boolean isSuitableTarget(LivingEntity entity, boolean targetInvulnerable) {
        if (entity == null || !(entity instanceof PixelmonEntity) && !(entity instanceof Player) || entity == this.taskOwner || !entity.m_6084_() || entity.m_21023_((MobEffect)EffectRegistration.AVOIDANCE.get())) {
            return false;
        }
        if (entity instanceof Player && this.taskOwner instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)this.taskOwner;
            Player player = (Player)entity;
            ItemStack heldItem = player.m_21205_();
            if (!heldItem.m_41619_() && heldItem.m_41720_() == PixelmonItems.trainer_editor && trainer.getAIMode().doesEngage() || !trainer.canStartBattle(player, false)) {
                return false;
            }
        }
        LivingEntity thisOwner = null;
        if (this.taskOwner instanceof PixelmonEntity) {
            thisOwner = ((PixelmonEntity)this.taskOwner).m_269323_();
        }
        if (thisOwner != null) {
            PixelmonEntity targetPokemon;
            if (entity instanceof PixelmonEntity && ((targetPokemon = (PixelmonEntity)entity).m_269323_() == thisOwner || targetPokemon.spawner != null)) {
                return false;
            }
            if (entity == ((TamableAnimal)this.taskOwner).m_269323_()) {
                return false;
            }
        } else {
            if (entity instanceof Player && !targetInvulnerable && ((Player)entity).m_150110_().f_35934_) {
                return false;
            }
            if (entity instanceof ServerPlayer) {
                int highestLevel;
                PlayerPartyStorage storage = StorageProxy.getPartyNow((ServerPlayer)entity);
                if (storage.countAblePokemon() < 1) {
                    return false;
                }
                if (RepelHandler.hasRepel((ServerPlayer)entity) && this.taskOwner instanceof PixelmonEntity && (highestLevel = storage.getHighestLevel()) > ((PixelmonEntity)this.taskOwner).getLvl().getPokemonLevel()) {
                    return false;
                }
                if (Pixelmon.EVENT_BUS.post((Event)new AggressionEvent(this.taskOwner, (ServerPlayer)entity))) {
                    return false;
                }
            }
        }
        if (this.shouldCheckSight && !this.taskOwner.m_21574_().m_148306_((Entity)entity)) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(entity) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        if (entity instanceof ServerPlayer) {
            if (((Player)entity).m_7500_() || entity.m_5833_()) {
                this.m_8041_();
                return false;
            }
            return EvolutionQueryList.get((Player)((ServerPlayer)entity)) == null;
        }
        return true;
    }

    private boolean canReach(LivingEntity par1EntityLiving) {
        int var5;
        this.reachCacheTime = 10 + RandomHelper.getRandom().nextInt(5);
        Path var2 = this.taskOwner.m_21573_().m_6570_((Entity)par1EntityLiving, 0);
        if (var2 == null) {
            return false;
        }
        Node var3 = var2.m_77395_();
        if (var3 == null) {
            return false;
        }
        int var4 = var3.f_77271_ - Mth.m_14107_((double)par1EntityLiving.m_20185_());
        return (double)(var4 * var4 + (var5 = var3.f_77271_ - Mth.m_14107_((double)par1EntityLiving.m_20189_())) * var5) <= 2.25;
    }
}

