/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.WorldHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SwimmingGoal
extends Goal {
    private PixelmonEntity pixelmon;
    private float swimSpeed = 1.5f;
    private float decayRate = 0.99f;
    private int depthRangeStart = 0;
    private int depthRangeEnd = 100;
    private float moveSpeed;
    private int ticksToRefresh;
    private double delta = 0.0;
    private boolean shouldSink = false;
    boolean lastChangeDirection;
    boolean useLastChangeDirection;

    public SwimmingGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
        if (entity.getSwimmingParameters() != null) {
            this.swimSpeed = entity.getSwimmingParameters().getSwimSpeed();
            this.decayRate = entity.getSwimmingParameters().getDecayRate();
            this.depthRangeStart = entity.getSwimmingParameters().getDepthRangeStart();
            this.depthRangeEnd = entity.getSwimmingParameters().getDepthRangeEnd();
            this.ticksToRefresh = entity.getSwimmingParameters().getRefreshRate();
            this.shouldSink = entity.getSwimmingParameters().isShouldSink();
        }
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.pixelmon.m_20069_() && this.pixelmon.battleController == null;
    }

    public void m_8037_() {
        if (this.shouldSink || this.depthRangeStart == -1) {
            this.pixelmon.m_20256_(new Vec3(0.0, -0.01, 0.0));
            return;
        }
        boolean useLastChangeDirection = false;
        BlockHitResult mop = this.pixelmon.f_19853_.m_45547_(new ClipContext(new Vec3(this.pixelmon.m_20185_(), this.pixelmon.m_20191_().f_82289_, this.pixelmon.m_20189_()), new Vec3(this.pixelmon.m_20185_() + this.pixelmon.m_20154_().f_82479_ * 5.0, this.pixelmon.m_20191_().f_82289_, this.pixelmon.m_20189_() + this.pixelmon.m_20154_().f_82481_ * 5.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.pixelmon));
        if (mop.m_6662_() == HitResult.Type.MISS) {
            mop = this.pixelmon.f_19853_.m_45547_(new ClipContext(new Vec3(this.pixelmon.m_20185_(), this.pixelmon.m_20191_().f_82292_, this.pixelmon.m_20189_()), new Vec3(this.pixelmon.m_20185_() + this.pixelmon.m_20154_().f_82479_ * 5.0, this.pixelmon.m_20191_().f_82289_, this.pixelmon.m_20189_() + this.pixelmon.m_20154_().f_82481_ * 5.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.pixelmon));
        }
        if (mop.m_6662_() != HitResult.Type.MISS) {
            useLastChangeDirection = true;
            this.lastChangeDirection = true;
        }
        --this.ticksToRefresh;
        if (this.moveSpeed == 0.0f || useLastChangeDirection || this.pixelmon.m_20184_().m_7096_() * this.pixelmon.m_20184_().m_7096_() + this.pixelmon.m_20184_().m_7094_() * this.pixelmon.m_20184_().m_7094_() < (double)(this.moveSpeed / 4.0f)) {
            this.pickDirection(useLastChangeDirection);
            this.pickSpeed();
            this.pixelmon.m_7023_(new Vec3(0.0, 0.0, (double)this.moveSpeed));
        }
    }

    public boolean m_8045_() {
        if (!this.pixelmon.m_20069_()) {
            return false;
        }
        this.moveSpeed *= this.decayRate;
        this.pixelmon.m_20334_(this.pixelmon.m_20184_().m_7096_() * (double)this.decayRate, this.pixelmon.m_20184_().m_7098_() * (double)this.decayRate, this.pixelmon.m_20184_().m_7094_() * (double)this.decayRate);
        this.pixelmon.f_20883_ = this.pixelmon.m_146908_();
        return true;
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = RandomHelper.getRandom().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = RandomHelper.getRandom().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.m_146922_((float)((double)this.pixelmon.m_146908_() + rotAmt));
    }

    public void pickSpeed() {
        if (this.ticksToRefresh < 0) {
            this.pixelmon.setSwimDepth(-1);
            this.ticksToRefresh = this.pixelmon.f_19853_.m_46472_() == DrownedWorld.WORLD ? 600 : (this.pixelmon.getSwimmingParameters() == null ? 160 : this.pixelmon.getSwimmingParameters().getRefreshRate());
        }
        this.moveSpeed = 2.8f * (RandomHelper.getRandom().nextFloat() * this.swimSpeed + this.swimSpeed / 2.0f);
        double refreshRate = 160.0;
        if (this.pixelmon.f_19853_.m_46472_() == DrownedWorld.WORLD) {
            refreshRate = 600.0;
        } else if (this.pixelmon.getSwimmingParameters() != null) {
            refreshRate = this.pixelmon.getSwimmingParameters().getRefreshRate();
        }
        if (refreshRate == 0.0) {
            refreshRate = 1.0;
        }
        double v = this.pixelmon.getSwimDepth();
        int wdepth = WorldHelper.getWaterDepth(this.pixelmon.m_20183_(), this.pixelmon.f_19853_);
        this.pixelmon.m_20256_(new Vec3(this.pixelmon.m_20184_().m_7096_(), ((double)wdepth - v) / refreshRate, this.pixelmon.m_20184_().m_7094_()));
    }
}

