/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FlyingPersistentGoal
extends Goal {
    protected PixelmonEntity pixelmon;
    private int ticksToChangeDirection = 0;
    private int ticksToChangeSpeed = 0;
    private float movespeed = 1.0f;
    private int directionChange = 1000;
    private int speedChange = 500;
    private boolean lastChangeDirection;
    private int initialHeight;
    private int ticksToRefresh;

    public FlyingPersistentGoal(PixelmonEntity entity) {
        if (entity.getFlyingParameters() != null) {
            this.movespeed = entity.getFlyingParameters().getFlySpeedModifier();
            this.directionChange = entity.getFlyingParameters().getFlyRefreshRateXZ();
            this.speedChange = entity.getFlyingParameters().getFlyRefreshRateSpeed();
            this.ticksToRefresh = entity.getFlyingParameters().getFlyRefreshRateY();
        }
        this.pixelmon = entity;
        this.initialHeight = Integer.MIN_VALUE;
    }

    public boolean m_8036_() {
        return this.pixelmon.getFlyingParameters() != null;
    }

    public boolean m_8045_() {
        return !this.pixelmon.grounded;
    }

    public void m_8041_() {
        this.pixelmon.f_21345_.m_25363_((Goal)this);
    }

    public void m_8037_() {
        if (this.initialHeight == Integer.MIN_VALUE) {
            this.initialHeight = (int)this.pixelmon.m_20186_();
        }
        --this.ticksToChangeDirection;
        boolean useLastChangeDirection = false;
        BlockHitResult mop = this.pixelmon.m_9236_().m_45547_(new ClipContext(new Vec3(this.pixelmon.m_20185_(), this.pixelmon.m_20191_().f_82289_, this.pixelmon.m_20189_()), new Vec3(this.pixelmon.m_20185_() + this.pixelmon.m_20184_().m_7096_() * 100.0, this.pixelmon.m_20191_().f_82289_, this.pixelmon.m_20189_() + this.pixelmon.m_20184_().m_7094_() * 100.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.pixelmon));
        if (mop.m_6662_() == HitResult.Type.MISS) {
            mop = this.pixelmon.m_9236_().m_45547_(new ClipContext(new Vec3(this.pixelmon.m_20185_(), this.pixelmon.m_20191_().f_82292_, this.pixelmon.m_20189_()), new Vec3(this.pixelmon.m_20185_() + this.pixelmon.m_20184_().m_7096_() * 100.0, this.pixelmon.m_20191_().f_82292_, this.pixelmon.m_20189_() + this.pixelmon.m_20184_().m_7094_() * 100.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.pixelmon));
        }
        if (mop.m_6662_() != HitResult.Type.MISS) {
            useLastChangeDirection = true;
            this.ticksToChangeDirection = 0;
        }
        if (this.ticksToChangeDirection <= 0 && this.directionChange > 0) {
            this.pickDirection(useLastChangeDirection);
            this.ticksToChangeDirection = 25 + RandomHelper.getRandom().nextInt(Math.max(1, this.directionChange));
        }
        this.pickSpeed();
        this.pickHeight();
        this.pixelmon.m_7023_(new Vec3(0.0, 0.0, (double)this.movespeed));
        super.m_8037_();
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = RandomHelper.getRandom().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = RandomHelper.getRandom().nextInt(40) - 20;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.m_146922_((float)((double)this.pixelmon.m_146908_() + rotAmt));
    }

    public void pickSpeed() {
        if (this.pixelmon.battleController != null) {
            this.movespeed = 0.0f;
            return;
        }
        if (this.ticksToChangeSpeed <= 0) {
            this.movespeed = RandomHelper.getRandom().nextFloat() * 0.7f + 1.0f;
            this.ticksToChangeSpeed = 50 + RandomHelper.getRandom().nextInt(Math.max(1, this.speedChange));
        }
        --this.ticksToChangeSpeed;
    }

    public void pickHeight() {
        if (this.pixelmon.getFlyingParameters() == null) {
            return;
        }
        if (this.ticksToRefresh < 0) {
            this.pixelmon.setFlyHeight(-1);
            this.ticksToRefresh = this.pixelmon.getFlyingParameters().getFlyRefreshRateY();
        }
        --this.ticksToRefresh;
        double refreshRate = this.pixelmon.getFlyingParameters().getFlyRefreshRateY();
        if (refreshRate == 0.0) {
            refreshRate = 1.0;
        }
        double v = this.initialHeight + this.pixelmon.getFlyHeight();
        EntityHelper.setMotion((Entity)this.pixelmon, EnumRotation.y, (v - (double)this.pixelmon.m_20183_().m_123342_()) / refreshRate);
    }
}

