/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FlyingGoal
extends Goal {
    private static final long OWNER_FIND_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private static final double OWNER_DISTANCE_TO_TAKEOFF = 100.0;
    private final PixelmonEntity pixelmon;
    private long nextOwnerCheckTime;
    private BlockPos currentFlightTarget;
    private int flightTicks = 0;
    private double takeOffSpeed = 0.0;
    private int targetHeight = 0;
    private boolean takingOff = false;
    private int nextWingBeat = 10;
    private int wingBeatTick = 0;
    boolean lastChangeDirection;

    public FlyingGoal(PixelmonEntity entity) {
        this.pixelmon = entity;
        this.nextOwnerCheckTime = System.currentTimeMillis();
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.pixelmon.m_20096_() && !this.pixelmon.m_5842_() && this.currentFlightTarget != null || this.pixelmon.m_269323_() != null || this.pixelmon.getFlyingParameters() == null) {
            return false;
        }
        return this.checkTakeOffConditions();
    }

    private boolean checkTakeOffConditions() {
        if (this.pixelmon.grounded) {
            return false;
        }
        if (this.pixelmon.m_269323_() != null && this.pixelmon.m_269323_().m_6084_() && this.pixelmon.m_20280_((Entity)this.pixelmon.m_269323_()) > 100.0) {
            return true;
        }
        Player nearest = this.pixelmon.m_9236_().m_45930_((Entity)this.pixelmon, 6.0);
        return nearest != null && nearest != this.pixelmon.m_269323_() || Math.random() < 0.015;
    }

    public boolean m_8045_() {
        return !this.pixelmon.m_20096_();
    }

    public void m_8056_() {
        this.takeOff();
    }

    public void m_8041_() {
        this.flightTicks = 0;
        this.currentFlightTarget = null;
        this.takingOff = false;
        this.targetHeight = 0;
        this.takeOffSpeed = 0.0;
    }

    public void m_8037_() {
        ++this.flightTicks;
        if (this.flightTicks > 100 && this.takingOff || this.takingOff && this.pixelmon.m_20186_() >= (double)this.targetHeight) {
            this.takingOff = false;
            this.flightTicks = 0;
        }
        if (this.takingOff) {
            this.pixelmon.m_20334_(this.pixelmon.m_20184_().m_7096_(), this.takeOffSpeed, this.pixelmon.m_20184_().m_7094_());
            this.pixelmon.m_246865_(this.pixelmon.m_20154_().m_82490_(0.02));
            if (this.pixelmon.f_185931_ || this.pixelmon.f_19862_) {
                this.m_8041_();
            }
            return;
        }
        if (this.pixelmon.m_269323_() != null) {
            this.lookForOwnerEntity();
        }
        this.checkForLandingSpot();
        AABB box = this.pixelmon.m_20191_();
        HitResult mop = this.checkIfHitboxWillFlyIntoBlock(box.f_82292_);
        if (mop.m_6662_() == HitResult.Type.MISS) {
            mop = this.checkIfHitboxWillFlyIntoBlock(box.f_82289_);
        }
        if (this.hasLandingSpot()) {
            if (mop.m_6662_() == HitResult.Type.MISS) {
                double d0 = (double)this.currentFlightTarget.m_123341_() + 0.5 - this.pixelmon.m_20185_();
                double d1 = (double)this.currentFlightTarget.m_123342_() + 0.1 - this.pixelmon.m_20186_();
                double d2 = (double)this.currentFlightTarget.m_123343_() + 0.5 - this.pixelmon.m_20189_();
                this.pixelmon.m_20334_(this.pixelmon.m_20184_().m_7096_() + (Math.signum(d0) - this.pixelmon.m_20184_().m_7096_()) * (double)0.1f, this.pixelmon.m_20184_().m_7098_() + (Math.signum(d1) * (double)0.7f - this.pixelmon.m_20184_().m_7098_()) * (double)0.1f, this.pixelmon.m_20184_().m_7094_() + (Math.signum(d2) - this.pixelmon.m_20184_().m_7094_()) * (double)0.1f);
                float f = (float)(Math.atan2(this.pixelmon.m_20184_().m_7094_(), this.pixelmon.m_20184_().m_7096_()) * 180.0 / Math.PI) - 90.0f;
                float f1 = Mth.m_14177_((float)(f - this.pixelmon.m_146908_()));
                this.pixelmon.m_146922_(this.pixelmon.m_146908_() + f1);
            }
        } else {
            this.maintainFlight(mop.m_6662_() != HitResult.Type.MISS);
        }
        super.m_8037_();
    }

    private void checkForLandingSpot() {
        if (!(this.currentFlightTarget == null || this.pixelmon.m_9236_().m_46859_(this.currentFlightTarget) && this.currentFlightTarget.m_123342_() >= -63)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || RandomHelper.getRandom().nextInt(30) == 0) {
            this.currentFlightTarget = new BlockPos((int)(this.pixelmon.m_20185_() + this.pixelmon.m_20184_().m_7096_() * 200.0 + (double)RandomHelper.getRandom().nextInt(50) - 25.0), 0, (int)(this.pixelmon.m_20189_() + this.pixelmon.m_20184_().m_7094_() * 200.0 + (double)RandomHelper.getRandom().nextInt(50) - 25.0));
            this.currentFlightTarget = this.pixelmon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, this.currentFlightTarget);
            if (!this.pixelmon.m_9236_().m_46859_(this.currentFlightTarget) || this.isLandingSpotAnAirBlockAboveWater(3)) {
                this.currentFlightTarget = null;
            }
        }
    }

    private boolean hasLandingSpot() {
        return this.currentFlightTarget != null;
    }

    private void maintainFlight(boolean hasObstacle) {
        ++this.wingBeatTick;
        if (hasObstacle || this.wingBeatTick >= this.nextWingBeat) {
            this.pickDirection(hasObstacle);
            this.nextWingBeat = this.pixelmon.getFlyingParameters().getFlapRate() + (int)(Math.random() * 0.4 * (double)this.pixelmon.getFlyingParameters().getFlapRate() - 0.2 * (double)this.pixelmon.getFlyingParameters().getFlapRate());
            this.pixelmon.m_7023_(new Vec3(0.0, 0.0, (double)(4.0f + (float)this.pixelmon.getPokemon().getStat(BattleStatsType.SPEED) / 100.0f * this.pixelmon.getFlyingParameters().getFlySpeedModifier())));
            this.pixelmon.m_20334_(this.pixelmon.m_20184_().m_7096_(), (double)(this.pixelmon.getFlyingParameters().getFlapRate() + 1) * 0.01, this.pixelmon.m_20184_().m_7094_());
            this.wingBeatTick = 0;
        }
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = RandomHelper.getRandom().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = RandomHelper.getRandom().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.m_146922_((float)((double)this.pixelmon.m_146908_() + rotAmt));
    }

    private void lookForOwnerEntity() {
        if (this.pixelmon.m_269323_() != null && System.currentTimeMillis() > this.nextOwnerCheckTime) {
            this.nextOwnerCheckTime = System.currentTimeMillis() + OWNER_FIND_INTERVAL;
            this.currentFlightTarget = new BlockPos((int)this.pixelmon.m_269323_().m_20185_(), (int)this.pixelmon.m_269323_().m_20186_() + 1, (int)this.pixelmon.m_269323_().m_20189_());
        }
    }

    private void takeOff() {
        this.pixelmon.setFlying(true);
        this.takingOff = true;
        this.flightTicks = 0;
        this.targetHeight = (int)this.pixelmon.m_20186_() + RandomHelper.getRandomNumberBetween(this.pixelmon.getFlyingParameters().getFlyHeightMin(), this.pixelmon.getFlyingParameters().getFlyHeightMax());
        this.takeOffSpeed = Math.max(0.05, 0.012 + (double)((float)this.pixelmon.getPokemon().getStat(BattleStatsType.SPEED) / 600.0f));
    }

    private boolean isLandingSpotAnAirBlockAboveWater(int amountOfBlocksToCheck) {
        for (int i = 0; i < amountOfBlocksToCheck; ++i) {
            if (!this.pixelmon.f_19853_.m_8055_(this.currentFlightTarget.m_6625_(i + 1)).m_60713_(Blocks.f_49990_) && !this.pixelmon.f_19853_.m_8055_(this.currentFlightTarget.m_6625_(i + 1)).m_60713_(Blocks.f_50016_)) {
                return false;
            }
            if (!this.pixelmon.f_19853_.m_8055_(this.currentFlightTarget.m_6625_(i + 1)).m_60713_(Blocks.f_49990_)) continue;
            return true;
        }
        return false;
    }

    private HitResult checkIfHitboxWillFlyIntoBlock(double hitBoxY) {
        return this.pixelmon.m_9236_().m_45547_(new ClipContext(new Vec3(this.pixelmon.m_20185_(), hitBoxY, this.pixelmon.m_20189_()), new Vec3(this.pixelmon.m_20185_() + this.pixelmon.m_20184_().m_7096_() * 100.0, hitBoxY, this.pixelmon.m_20189_() + this.pixelmon.m_20184_().m_7094_() * 100.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this.pixelmon));
    }
}

