/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ExecuteActionGoal
extends Goal {
    private Mob parent;
    private MoveSkill moveSkill = null;

    public ExecuteActionGoal(Mob entity) {
        this.parent = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity attackTarget;
        if (this.parent.m_5448_() == null) {
            return false;
        }
        if (this.parent instanceof PixelmonEntity) {
            ServerPlayer player;
            PixelmonEntity pokemon = (PixelmonEntity)this.parent;
            if (pokemon.getAggressionTimer() > 0) {
                return false;
            }
            if (pokemon.battleController != null) {
                return false;
            }
            if (pokemon.hitByPokeball != null) {
                return false;
            }
            if (pokemon.getBossTier().isBoss()) {
                return false;
            }
            if (pokemon.m_269323_() != null && BattleRegistry.getBattle((Player)(player = (ServerPlayer)pokemon.m_269323_())) != null) {
                return false;
            }
        } else if (((NPCTrainer)this.parent).battleController != null) {
            return false;
        }
        if ((attackTarget = this.parent.m_5448_()) instanceof Player && (((Player)attackTarget).m_7500_() || attackTarget.m_5833_())) {
            this.parent.m_6710_(null);
            return false;
        }
        double distance = 2.0;
        if (this.parent instanceof NPCTrainer) {
            distance = ((NPCTrainer)this.parent).getEngageDistance();
        }
        if (this.parent instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)this.parent;
            String skillId = pixelmon.skillId;
            if (skillId != null) {
                this.moveSkill = MoveSkill.getMoveSkillByID(skillId);
                if (this.moveSkill != null) {
                    distance = this.moveSkill.range;
                }
            }
        }
        return (double)attackTarget.m_20270_((Entity)this.parent) < distance;
    }

    public void m_8056_() {
    }

    public void m_8037_() {
        LivingEntity attackTarget = this.parent.m_5448_();
        this.parent.m_6710_(null);
        if (this.parent instanceof PixelmonEntity) {
            ((PixelmonEntity)this.parent).update(EnumUpdateType.Target);
        }
        if (this.parent instanceof PixelmonEntity) {
            PixelmonEntity user = (PixelmonEntity)this.parent;
            if (this.moveSkill != null) {
                if (attackTarget instanceof PixelmonEntity && this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.POKEMON)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.POKEMON);
                } else if (attackTarget instanceof ServerPlayer && this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.PLAYER)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.PLAYER);
                } else if (this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.MISC_ENTITY)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.MISC_ENTITY);
                }
                return;
            }
        }
        if (attackTarget instanceof Player) {
            Pokemon firstPokemon;
            BlockItem currentItemBlock;
            ServerPlayer player = (ServerPlayer)attackTarget;
            if (BattleRegistry.getBattle((Player)player) != null) {
                return;
            }
            if (this.parent instanceof NPCTrainer && !((NPCTrainer)this.parent).canStartBattle((Player)player, false)) {
                return;
            }
            if (this.parent instanceof PixelmonEntity && ((PixelmonEntity)this.parent).belongsTo((Player)player)) {
                return;
            }
            if (player.m_21023_((MobEffect)EffectRegistration.AVOIDANCE.get())) {
                return;
            }
            Item currentItem = ((ItemStack)player.m_150109_().f_35974_.get(player.m_150109_().f_35977_)).m_41720_();
            if (currentItem == PixelmonItems.trainer_editor) {
                return;
            }
            if (currentItem instanceof BlockItem && (currentItemBlock = (BlockItem)currentItem).m_40614_() == PixelmonBlocks.pixelmon_spawner) {
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
            if (storage.guiOpened || storage.countAblePokemon() < 1) {
                return;
            }
            BattleType battleType = BattleType.SINGLE;
            if (this.parent instanceof NPCTrainer) {
                NPCTrainer trainer = (NPCTrainer)this.parent;
                battleType = trainer.getBattleType();
                if (!trainer.battleRules.isDefault()) {
                    TeamSelectionRegistry.addTeamSelection(trainer.battleRules, true, trainer.getPokemonStorage(), StorageProxy.getPartyNow(player));
                    return;
                }
            }
            if ((firstPokemon = storage.findOne(Pokemon::canBattle)) == null) {
                return;
            }
            PixelmonEntity pixelmon = firstPokemon.getOrSpawnPixelmon((Entity)player);
            PlayerParticipant playerPart = battleType == BattleType.SINGLE ? new PlayerParticipant(player, pixelmon) : new PlayerParticipant(player, storage.findAll(Pokemon::canBattle), battleType.getNumPokemon());
            BattleParticipant participant = this.getThisParticipant(attackTarget);
            if (participant instanceof PlayerParticipant && this.parent instanceof PixelmonEntity) {
                new BattleQuery((ServerPlayer)((PixelmonEntity)this.parent).m_269323_(), (PixelmonEntity)this.parent, player, pixelmon);
            } else if (pixelmon != null) {
                pixelmon.startBattle(playerPart, participant);
            }
            return;
        }
        if (!(this.parent instanceof PixelmonEntity)) {
            return;
        }
        PixelmonEntity userPokemon = (PixelmonEntity)this.parent;
        if (attackTarget instanceof NPCTrainer) {
            NPCTrainer trainerEntity = (NPCTrainer)attackTarget;
            if (!trainerEntity.canStartBattle((Player)((ServerPlayer)((PixelmonEntity)this.parent).m_269323_()), true)) {
                return;
            }
            BattleController bc = trainerEntity.getBattleController();
            if (bc != null) {
                if (bc.battleEnded) {
                    bc.endBattle(BattleEndCause.FORCE);
                } else {
                    ChatHandler.sendChat((Entity)userPokemon.m_269323_(), "pixelmon.entitytrainer.inbattle", new Object[0]);
                    return;
                }
            }
            BattleType battleType = trainerEntity.getBattleType();
            BattleParticipant participant = this.getThisParticipant(attackTarget);
            if (participant instanceof PlayerParticipant && userPokemon.m_269323_() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)userPokemon.m_269323_();
                if (trainerEntity.battleRules.isDefault()) {
                    if (userPokemon != null) {
                        PlayerParticipant playerPart;
                        userPokemon.onSendout();
                        TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (Player)player, battleType.getNumPokemon());
                        if (battleType == BattleType.SINGLE) {
                            playerPart = new PlayerParticipant(player, userPokemon);
                        } else {
                            PlayerPartyStorage storage = StorageProxy.getPartyNow(player);
                            ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                            list.add(userPokemon.getPokemon());
                            list.addAll(storage.getTeam().stream().filter(p -> !p.isFainted() && p != userPokemon.getPokemon()).collect(Collectors.toList()));
                            playerPart = new PlayerParticipant(player, list, 2);
                        }
                        userPokemon.startBattle((BattleParticipant)playerPart, (BattleParticipant)trainer, trainerEntity.battleRules);
                    }
                } else {
                    TeamSelectionRegistry.addTeamSelection(trainerEntity.battleRules, true, trainerEntity.getPokemonStorage(), StorageProxy.getPartyNow(player));
                }
                return;
            }
        }
        if (!(attackTarget instanceof PixelmonEntity)) {
            return;
        }
        PixelmonEntity target = (PixelmonEntity)attackTarget;
        BattleParticipant participant = this.getThisParticipant(attackTarget);
        if (participant instanceof WildPixelmonParticipant) {
            if (target.getBossTier().isBoss() || userPokemon.getBossTier().isBoss()) {
                return;
            }
            if (target.hasPalette() || userPokemon.hasPalette()) {
                return;
            }
            if (target.m_269323_() != null) {
                return;
            }
        }
        if (target.hitByPokeball != null) {
            return;
        }
        if (target.battleController != null) {
            return;
        }
        if (target.m_21223_() <= 0.0f || !target.m_6084_()) {
            return;
        }
        if (target.m_269323_() == null) {
            userPokemon.startBattle(participant, new WildPixelmonParticipant(target));
        } else if (userPokemon.m_269323_() != target.m_269323_()) {
            new BattleQuery((ServerPlayer)userPokemon.m_269323_(), userPokemon, (ServerPlayer)target.m_269323_(), target);
        }
    }

    private BattleParticipant getThisParticipant(LivingEntity attackTarget) throws IllegalStateException {
        if (this.parent instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)this.parent;
            return new TrainerParticipant(trainer, (Player)((ServerPlayer)attackTarget), trainer.getBattleType().getNumPokemon());
        }
        PixelmonEntity pixelmon = (PixelmonEntity)this.parent;
        if (pixelmon.hasOwner()) {
            return new PlayerParticipant((ServerPlayer)pixelmon.m_269323_(), pixelmon);
        }
        return new WildPixelmonParticipant(pixelmon);
    }
}

