/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.TimeHandler;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.effects.PassiveEffectProxy;
import com.pixelmonmod.pixelmon.api.pokemon.hatch.EggHatcherProxy;
import com.pixelmonmod.pixelmon.api.pokemon.healing.PassiveHealingProxy;
import com.pixelmonmod.pixelmon.api.pokemon.lure.LureExpiringProxy;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.starter.ChooseStarterScreen;
import com.pixelmonmod.pixelmon.client.render.OverlayToggles;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.GuiOpenClosePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.StarterListPacket;
import com.pixelmonmod.pixelmon.entities.DenEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class TickHandler {
    boolean screenOpen = false;
    boolean initialised = false;
    public int worldCounter;
    private int ticksSincePlayersCheck = 0;
    private static final Set<UUID> playerListForStartMenu = Sets.newConcurrentHashSet();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        if (player.f_36083_ != null) {
            FishingHook hook = player.f_36083_;
            if (hook.f_37094_ instanceof DenEntity) {
                hook.f_37094_ = null;
            }
        }
        if (BattleRegistry.getBattle((Player)player) != null) {
            player.m_20091_();
        }
        PlayerPartyStorage pps = StorageProxy.getPartyNow(player);
        EggHatcherProxy.tick(player, pps);
        PassiveHealingProxy.tick(player, pps);
        PassiveEffectProxy.tick(player, pps);
        LureExpiringProxy.tick(player, pps, pps.getLureStack());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (ServerStorageDisplay.showStarterScreen && Minecraft.m_91087_().f_91080_ == null) {
            try {
                if (ClientStorageManager.party != null && ClientStorageManager.party.countAll() > 0) {
                    ServerStorageDisplay.showStarterScreen = false;
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)new ChooseStarterScreen());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (!(Minecraft.m_91087_().f_91080_ == null || this.screenOpen && this.initialised || Minecraft.m_91087_().f_91080_ instanceof ChatScreen)) {
            NetworkHelper.sendToServer(new GuiOpenClosePacket(true));
            this.screenOpen = true;
            this.initialised = true;
        } else if (this.screenOpen && Minecraft.m_91087_().f_91080_ == null || !this.initialised) {
            NetworkHelper.sendToServer(new GuiOpenClosePacket(false));
            this.screenOpen = false;
            this.initialised = true;
            if (Minecraft.m_91087_().f_91066_.f_92062_ || OverlayToggles.contains(VanillaGuiOverlay.HOTBAR)) {
                Minecraft.m_91087_().f_91066_.f_92062_ = false;
                OverlayToggles.resetOverlays();
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Scheduling.tick();
            return;
        }
        if (this.worldCounter % (PixelmonConfigProxy.getGeneral().getTimeUpdateInterval() * 20) == 0) {
            TimeHandler.changeTime();
        }
        BattleController.currentAnimations.removeIf(animation -> {
            try {
                if (animation.user.entity == null || animation.target.entity == null) {
                    return true;
                }
                return animation.tickAnimation(++animation.ticks);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        });
        if (!playerListForStartMenu.isEmpty() && this.worldCounter % 100 == 0) {
            for (UUID uuid : playerListForStartMenu) {
                ServerPlayer player = event.getServer().m_6846_().m_11259_(uuid);
                if (player == null) continue;
                NetworkHelper.sendPacket(player, new StarterListPacket());
            }
        }
        if (++this.ticksSincePlayersCheck >= 20) {
            this.ticksSincePlayersCheck = 0;
            for (PokemonStorage storage : StorageProxy.getAllCachedStorages()) {
                if (!(storage instanceof PlayerPartyStorage)) continue;
                PlayerPartyStorage party = (PlayerPartyStorage)storage;
                party.checkPokerus();
            }
        }
        ++this.worldCounter;
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            WorldTime.getCurrent(event.level);
            EvolutionQueryList.tick(event.level);
            LearnMoveController.tick(event.level);
        }
    }

    public static void registerStarterList(ServerPlayer player) {
        if (playerListForStartMenu.contains(player.m_20148_())) {
            return;
        }
        playerListForStartMenu.add(player.m_20148_());
        NetworkHelper.sendPacket(player, new StarterListPacket());
    }

    public static void deregisterStarterList(ServerPlayer player) {
        playerListForStartMenu.remove(player.m_20148_());
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && event.getEntity() == Minecraft.m_91087_().f_91074_) {
            PlayerExtraDataStore.sendDisplayPacket();
        }
    }
}

