/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonSendOutEvent;
import com.pixelmonmod.pixelmon.api.events.moveskills.UseMoveSkillEvent;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonPalettes;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.SpriteItemHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCDataPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.MemoryItem;
import com.pixelmonmod.pixelmon.items.heldItems.PlateItem;
import com.pixelmonmod.pixelmon.items.heldItems.ZCrystalItem;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoField;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PixelmonEventHandler {
    @SubscribeEvent
    public static void structureVoidHelper(PlayerInteractEvent.RightClickBlock event) {
        if (Pixelmon.isDevEnvironment() && event.getEntity() instanceof ServerPlayer && event.getHand() == InteractionHand.MAIN_HAND && event.getFace() != null && event.getItemStack().m_41720_() == Item.m_41439_((Block)Blocks.f_50454_) && event.getLevel().m_8055_(event.getHitVec().m_82425_()).m_60734_() == Blocks.f_50454_) {
            BlockPos pos = event.getPos().m_121945_(event.getFace());
            for (int i = 0; i < event.getItemStack().m_41613_(); ++i) {
                event.getLevel().m_46597_(pos, Blocks.f_50454_.m_49966_());
                event.getLevel().m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pos = pos.m_121945_(event.getFace());
            }
        }
    }

    @SubscribeEvent
    public void onLightning(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof LightningBolt) {
            LightningBolt bolt = (LightningBolt)event.getEntity();
            Level world = event.getLevel();
            if (world.m_5776_()) {
                return;
            }
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(bolt.m_20185_(), (double)world.m_141928_(), bolt.m_20189_());
            BlockState block = world.m_8055_((BlockPos)mutablePos);
            while (block.m_60795_() && mutablePos.m_123342_() > world.m_6042_().f_156647_()) {
                mutablePos.m_142448_(mutablePos.m_123342_() - 1);
                block = world.m_8055_((BlockPos)mutablePos);
            }
            if (world.m_8055_((BlockPos)mutablePos).m_60734_() == Blocks.f_50069_) {
                world.m_7731_((BlockPos)mutablePos, PixelmonBlocks.thunder_stone_ore.m_49966_(), 3);
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -2; y <= 0; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (!RandomHelper.getRandomChance(0.05f)) continue;
                            BlockPos.MutableBlockPos pos = mutablePos.m_122184_(x, y, z);
                            if (world.m_8055_((BlockPos)pos).m_60734_() == Blocks.f_50069_) {
                                world.m_7731_((BlockPos)pos, PixelmonBlocks.thunder_stone_ore.m_49966_(), 3);
                            }
                            mutablePos.m_122184_(-x, -y, -z);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMoveSkillUsed(UseMoveSkillEvent event) {
        ServerPlayer trainer = event.pixelmon.getPokemon().getOwnerPlayer();
        if (Objects.equals(event.moveSkill.id, "forage") && event.pixelmon.getSpecies().is(PixelmonSpecies.PICHU) && event.pixelmon.getPokemon().getFriendship() == 255 && !event.pixelmon.getPokemon().getPersistentData().m_128471_("Pichu_friend") && event.data instanceof Tuple && StorageProxy.getPartyNow(trainer).hasSpace()) {
            Tuple data = (Tuple)event.data;
            if (event.pixelmon.m_9236_().m_8055_((BlockPos)data.m_14418_()).m_60734_() == PixelmonBlocks.ilex_shrine) {
                event.pixelmon.getPokemon().getPersistentData().m_128379_("Pichu_friend", true);
                Pokemon pichu = PokemonFactory.create(PixelmonSpecies.PICHU.getValueUnsafe());
                pichu.setGender(Gender.FEMALE);
                pichu.setLevel(30);
                pichu.setForm("spiky");
                pichu.setAbility(AbilityRegistry.STATIC);
                pichu.setHeldItem(new ItemStack((ItemLike)PixelmonItems.zap_plate.m_5456_()));
                pichu.getMoveset().set(0, new Attack(AttackRegistry.VOLT_TACKLE));
                pichu.getMoveset().set(1, new Attack(AttackRegistry.HELPING_HAND));
                pichu.getMoveset().set(2, new Attack(AttackRegistry.SWAGGER));
                pichu.getMoveset().set(3, new Attack(AttackRegistry.PAIN_SPLIT));
                pichu.getPersistentData().m_128379_("Pichu_friend", true);
                StorageProxy.getPartyNow(trainer).add(pichu);
                NPCChatEvent event2 = new NPCChatEvent(null, (Player)trainer, Lists.newArrayList((Object[])new String[]{"event.spikepichu"}));
                if (!Pixelmon.EVENT_BUS.post((Event)event2)) {
                    NetworkHelper.sendPacket(trainer, new SetNPCDataPacket("", event2.getChat()));
                    OpenScreenPacket.open((Player)trainer, EnumGuiScreen.NPCChat, -1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBeatPokemon(BeatWildPixelmonEvent event) {
        PixelmonAdvancements.throwBattleTriggers(event.player);
        if (PixelmonConfigProxy.getGeneral().isAwardTokens()) {
            for (PixelmonWrapper wrapper : event.wpp.controlledPokemon) {
                PixelmonEntity pokemon = wrapper.entity;
                event.player.m_150109_().m_36054_(SpriteItemHelper.getPhoto(pokemon.getPokemon()));
            }
        }
    }

    @SubscribeEvent
    public void onChristmasDelibird(BeatWildPixelmonEvent event) {
        SpawnerCoordinator.PROCESSOR.submit(() -> {
            if (event.wpp.controlledPokemon.stream().anyMatch(it -> it.pokemon.getSpecies().is(PixelmonSpecies.DELIBIRD))) {
                PlayerPartyStorage party = StorageProxy.getPartyNow(event.player);
                LocalDate now = LocalDate.now();
                int year = now.get(ChronoField.YEAR);
                Month month = now.getMonth();
                int day = now.getDayOfMonth();
                if (month == Month.DECEMBER && day >= 20 && day <= 31 && !party.playerData.getWasGifted(year)) {
                    ChatHandler.sendChat((Entity)event.player, "christmas.received", new Object[0]);
                    event.player.m_150109_().m_36054_(new ItemStack((ItemLike)PixelmonItems.gift_box));
                    party.playerData.receivedGift(year);
                }
            }
        });
    }

    @SubscribeEvent
    public void onHeldItemChanged(HeldItemChangedEvent.Post event) {
        if (event.getSpecies().is(PixelmonSpecies.GIRATINA)) {
            if (event.getPokemon().getForm().isForm("altered") && event.getHeldItem().m_41720_() == PixelmonItems.griseous_orb) {
                event.getPokemon().setForm("origin");
                if (event.getPlayer() != null) {
                    ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", "Giratina");
                }
            } else if (event.getPokemon().getForm().isForm("origin") && event.getHeldItem().m_41720_() != PixelmonItems.griseous_orb) {
                event.getPokemon().setForm("altered");
                if (event.getPlayer() != null) {
                    ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", "Giratina");
                }
            }
        } else if (event.getSpecies().is(PixelmonSpecies.ARCEUS)) {
            Element type;
            if (event.getHeldItem().m_41619_() || !(event.getHeldItem().m_41720_() instanceof PlateItem) && !(event.getHeldItem().m_41720_() instanceof ZCrystalItem)) {
                type = Element.NORMAL;
            } else if (event.getHeldItem().m_41720_() instanceof PlateItem) {
                type = ((PlateItem)event.getHeldItem().m_41720_()).getType();
            } else {
                ZCrystalItem zCrystalItem = (ZCrystalItem)event.getHeldItem().m_41720_();
                type = zCrystalItem.type.affiliatedType != null ? zCrystalItem.type.affiliatedType : Element.NORMAL;
            }
            String newForm = PixelmonForms.getFromType(type);
            event.getPokemon().setForm(newForm);
        } else if (event.getSpecies().is(PixelmonSpecies.SILVALLY)) {
            Item item;
            String newForm = PixelmonForms.NONE;
            if (!event.getHeldItem().m_41619_() && (item = event.getHeldItem().m_41720_()) instanceof MemoryItem) {
                newForm = PixelmonForms.getFromType(((MemoryItem)item).type);
            }
            event.getPokemon().setForm(newForm);
        } else if (event.getSpecies().is(PixelmonSpecies.GENESECT)) {
            String newForm = PixelmonForms.NONE;
            if (!event.getHeldItem().m_41619_()) {
                Item item = event.getHeldItem().m_41720_();
                if (item == PixelmonItems.burn_drive) {
                    newForm = "burn";
                } else if (item == PixelmonItems.chill_drive) {
                    newForm = "chill";
                } else if (item == PixelmonItems.douse_drive) {
                    newForm = "douse";
                } else if (item == PixelmonItems.shock_drive) {
                    newForm = "shock";
                }
            }
            event.getPokemon().setForm(newForm);
            if (event.getPlayer() != null) {
                ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", "Genesect");
            }
        }
    }

    @SubscribeEvent
    public void onSentOut(PokemonSendOutEvent event) {
        if (event.getPokemon().getSpecies().is(PixelmonSpecies.SHAYMIN)) {
            if (event.getPokemon().getForm().isForm("sky") && !event.getPlayer().m_9236_().m_46461_()) {
                event.getPokemon().setForm("land");
                ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", event.getPokemon().getDisplayName());
            }
        } else if (event.getPokemon().getSpecies().is(PixelmonSpecies.CHERRIM)) {
            if (event.getPokemon().getForm().isForm("sunshine")) {
                event.getPokemon().setForm("overcast");
            }
        } else if (!event.getPokemon().getSpecies().is(PixelmonSpecies.TOXTRICITY) && event.getPokemon().getSpecies().is(PixelmonSpecies.HOOPA) && event.getPokemon().getForm().isForm("unbound") && System.currentTimeMillis() > event.getPokemon().getPersistentData().m_128454_("unboundTime") + 3600000L) {
            event.getPokemon().setForm("confined");
            event.getPokemon().getPersistentData().m_128473_("unboundTime");
            ChatHandler.sendChat((Entity)event.getPlayer(), "pixelmon.abilities.changeform", event.getPokemon().getDisplayName());
        }
    }

    @SubscribeEvent
    public void onMoveLearned(MovesetEvent.LearntMoveEvent event) {
        if (event.pokemon.getSpecies().is(PixelmonSpecies.KELDEO)) {
            if (event.learntAttack.isAttack(AttackRegistry.SECRET_SWORD) && event.pokemon.getForm().isForm("ordinary")) {
                event.pokemon.setForm("resolute");
            } else if (!event.moveset.hasAttack(AttackRegistry.SECRET_SWORD) && event.pokemon.getForm().isForm("resolute")) {
                event.pokemon.setForm("ordinary");
            }
        }
    }

    @SubscribeEvent
    public void onMoveForgot(MovesetEvent.ForgotMoveEvent event) {
        if (event.pokemon.getSpecies().is(PixelmonSpecies.KELDEO) && event.forgottenAttack.isAttack(AttackRegistry.SECRET_SWORD)) {
            event.pokemon.setForm("ordinary");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPokemonSpawn(SpawnEvent event) {
        if (event.action instanceof SpawnActionPokemon) {
            SpawnActionPokemon spawnPokemon = (SpawnActionPokemon)event.action;
            if (event.action.spawnLocation.types.contains(LocationType.OAS_ROD)) {
                FormLogRegistry.assignRandomFish(spawnPokemon);
            } else if (!(event.action.spawnLocation.types.contains(LocationType.WATER) || event.action.spawnLocation.types.contains(LocationType.SURFACE_WATER) || event.action.spawnLocation.types.contains(LocationType.UNDERGROUND_WATER) || event.action.spawnLocation.types.contains(LocationType.SEAFLOOR) || event.action.spawnLocation.types.contains(LocationType.SEAWEED) || event.action.spawnLocation.types.contains(LocationType.LAVA) || event.action.spawnLocation.types.contains(LocationType.SURFACE_LAVA) || event.action.spawnLocation.types.contains(LocationType.UNDERGROUND_LAVA))) {
                int rodQuality = 0;
                if (event.action.spawnLocation.types.contains(LocationType.SUPREME_ROD_QUALITY)) {
                    rodQuality = 6;
                } else if (event.action.spawnLocation.types.contains(LocationType.PRO_ROD_QUALITY)) {
                    rodQuality = 5;
                } else if (event.action.spawnLocation.types.contains(LocationType.RARE_ROD_QUALITY)) {
                    rodQuality = 4;
                } else if (event.action.spawnLocation.types.contains(LocationType.GREAT_ROD_QUALITY)) {
                    rodQuality = 3;
                } else if (event.action.spawnLocation.types.contains(LocationType.GOOD_ROD_QUALITY)) {
                    rodQuality = 2;
                } else if (event.action.spawnLocation.types.contains(LocationType.SO_SO_ROD_QUALITY)) {
                    rodQuality = 1;
                } else if (event.action.spawnLocation.types.contains(LocationType.OK_ROD_QUALITY)) {
                    rodQuality = 0;
                } else {
                    return;
                }
                Species species = spawnPokemon.pokemon.getSpecies();
                PixelmonEntity pokemon = (PixelmonEntity)((Object)spawnPokemon.getOrCreateEntity());
                if (pokemon != null && !pokemon.isPalette("shiny")) {
                    String palette = PixelmonPalettes.getJumpPalette(pokemon.getSpecies(), rodQuality);
                    if (species.is(PixelmonSpecies.MAGIKARP)) {
                        if (CollectionHelper.anyMatch(event.action.spawnLocation.types, Sets.newHashSet((Object[])new LocationType[]{LocationType.OLD_ROD_LAVA, LocationType.GOOD_ROD_LAVA, LocationType.SUPER_ROD_LAVA}))) {
                            pokemon.getPokemon().setPalette("roasted");
                        } else if (palette.equals("karp")) {
                            pokemon.getPokemon().setSpecies(PixelmonSpecies.FEEBAS, true);
                        }
                    }
                    if (!pokemon.isPalette("none")) {
                        pokemon.getPokemon().setPalette(palette);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onReceive(PokemonReceivedEvent event) {
        ServerPlayer player = event.getPlayer();
        PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
        if (event.getCause().equals("Starter")) {
            PixelmonAdvancements.STARTER_TRIGGER.trigger(player);
        }
    }
}

