/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.PixelmonEventHandler;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.daycare.PixelmonDayCare;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.events.init.PixelmonInitEvent;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicProxy;
import com.pixelmonmod.pixelmon.api.pokemon.egg.impl.PixelmonBreedingLogic;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonTypeRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonRequirements;
import com.pixelmonmod.pixelmon.api.registries.PixelmonTicketType;
import com.pixelmonmod.pixelmon.api.registries.StatueRequirements;
import com.pixelmonmod.pixelmon.api.rules.PixelmonGameRules;
import com.pixelmonmod.pixelmon.api.storage.PixelmonStorageManager;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.test.BattleTestRegistry;
import com.pixelmonmod.pixelmon.client.BuildCreativeMenuTabs;
import com.pixelmonmod.pixelmon.client.render.shader.PixelmonCodecs;
import com.pixelmonmod.pixelmon.comm.PacketRegistry;
import com.pixelmonmod.pixelmon.command.PixelmonCommands;
import com.pixelmonmod.pixelmon.dev.DevTools;
import com.pixelmonmod.pixelmon.init.registry.BlockRegistration;
import com.pixelmonmod.pixelmon.init.registry.ContainerRegistration;
import com.pixelmonmod.pixelmon.init.registry.CreativeModeTabRegistration;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.FireworkRegistration;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.init.registry.PaintingTypeRegistry;
import com.pixelmonmod.pixelmon.init.registry.ParticleRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonBlockTags;
import com.pixelmonmod.pixelmon.init.registry.PixelmonItemTags;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import com.pixelmonmod.pixelmon.init.registry.RecipeTypeRegistration;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.pixelmonmod.pixelmon.init.registry.StructurePieceTypeRegistry;
import com.pixelmonmod.pixelmon.init.registry.StructureTypeRegistry;
import com.pixelmonmod.pixelmon.init.registry.TileEntityRegistration;
import com.pixelmonmod.pixelmon.listener.PokemonSpecialShadersListener;
import com.pixelmonmod.pixelmon.listener.UnbattleableListener;
import com.pixelmonmod.pixelmon.listener.UncatchableListener;
import com.pixelmonmod.pixelmon.listener.UndexableListener;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.storage.adapters.NBTStorageSaveAdapter;
import com.pixelmonmod.pixelmon.storage.schedulers.PixelmonStorageAsyncScheduler;
import com.pixelmonmod.pixelmon.world.dimension.DimensionRegistration;
import com.pixelmonmod.pixelmon.world.generation.BlockStateProviderTypes;
import com.pixelmonmod.pixelmon.world.generation.FoliageRegistration;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeature;
import com.pixelmonmod.pixelmon.world.generation.TreeDecoratorTypes;
import com.pixelmonmod.pixelmon.world.generation.TrunkRegistration;
import com.pixelmonmod.pixelmon.world.structure.PixelmonPoolElementTypes;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="pixelmon")
public class Pixelmon {
    public static final String MODID = "pixelmon";
    public static final String NAME = "Pixelmon";
    public static final int NET_VERSION = 923;
    public static final String VERSION = "9.2.6";
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ExecutorService POOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("pixelmon_common_%d").build());
    public static final boolean LOG_PACKETS = Boolean.parseBoolean(System.getProperty("pixelmon.log_packets"));
    public static final boolean LOG_BATTLE_SCREEN_MODE = Boolean.parseBoolean(System.getProperty("pixelmon.client.log_battle_mode"));
    public static final Random random = new Random();
    public static Pixelmon instance;
    public static CommonProxy proxy;
    public static File modDirectory;
    public static SimpleChannel network;
    public static boolean freeze;
    public static boolean canSendOutPokemon;

    public Pixelmon() {
        PixelmonGameRules.init();
        PixelmonRequirements.init();
        StatueRequirements.init();
        PixelmonConfigProxy.reload();
        BattleTestRegistry.init();
        PixelmonCodecs.init();
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Pixelmon::init);
        bus.addListener(CommonProxy::init);
        bus.addListener(Pixelmon::postInit);
        bus.addListener(CommonProxy::postInit);
        bus.addListener(EntityRegistration::registerAttributes);
        bus.addListener(BuildCreativeMenuTabs::addToCreativeMenuTabs);
        PixelmonTicketType.init();
        PaintingTypeRegistry.PAINTINGS.register(bus);
        ItemRegistration.ITEMS.register(bus);
        BlockRegistration.BLOCKS.register(bus);
        EffectRegistration.EFFECTS.register(bus);
        DimensionRegistration.CHUNK_GENERATOR.register(bus);
        TileEntityRegistration.TILE_ENTITIES.register(bus);
        EntityRegistration.ENTITIES.register(bus);
        CreativeModeTabRegistration.TABS.register(bus);
        ParticleRegistration.PARTICLES_TYPES.register(bus);
        ContainerRegistration.CONTAINERS.register(bus);
        FoliageRegistration.FOLIAGE_PLACER_TYPES.register(bus);
        TreeDecoratorTypes.TREE_DECORATOR_TYPES.register(bus);
        BlockStateProviderTypes.BLOCK_STATE_PROVIDER_TYPE.register(bus);
        SoundRegistration.SOUNDS.register(bus);
        PixelmonFeature.FEATURES.register(bus);
        PixelmonPoolElementTypes.ELEMENT_TYPES.register(bus);
        PixelmonPoolElementTypes.STRUCTURE_TYPES.register(bus);
        TrunkRegistration.TRUNK_PLACER_TYPE.register(bus);
        StructureTypeRegistry.STRUCTURE_TYPE.register(bus);
        StructurePieceTypeRegistry.STRUCTURE_PIECE.register(bus);
        RecipeTypeRegistration.register(bus);
        PixelmonItemTags.bootstrap();
        PixelmonEggGroups.init();
        new UnbattleableListener();
        new UncatchableListener();
        new UndexableListener();
        PixelmonDataSerializers.bootstrap();
        PixelmonBlockTags.bootstrap();
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LOGGER.info("Loading Pixelmon version 9.2.6");
        FireworkRegistration.init();
        network = ChannelBuilder.named((String)MODID).networkProtocolVersion(923).optionalServer().clientAcceptedVersions(Channel.VersionTest.exact((int)923)).simpleChannel();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        PacketRegistry.registerPackets();
        modDirectory = new File("");
        PixelmonAdvancements.init();
        PixelmonEventHandler eventHandler = new PixelmonEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        EVENT_BUS.register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register(PokemonSpecialShadersListener.class);
        PixelmonStorageManager storageManager = new PixelmonStorageManager();
        PixelmonBreedingLogic pixelmonBreedingLogic = new PixelmonBreedingLogic();
        PixelmonInitEvent initEvent = new PixelmonInitEvent(storageManager, new NBTStorageSaveAdapter(), new PixelmonStorageAsyncScheduler(), pixelmonBreedingLogic);
        EVENT_BUS.post((Event)initEvent);
        RibbonTypeRegistry.bootstrap();
        if (StorageProxy.getStorageManager() == null) {
            StorageProxy.setStorageManager(initEvent.getStorageManager());
        }
        if (StorageProxy.getSaveScheduler() == null) {
            StorageProxy.setSaveScheduler(initEvent.getSaveScheduler());
        }
        if (StorageProxy.getSaveAdapter() == null) {
            StorageProxy.setSaveAdapter(initEvent.getSaveAdapter());
        }
        if (!BankAccountProxy.hasImplementation()) {
            BankAccountProxy.setAccountManager(initEvent.getBankAccountManager());
        }
        if (!BreedingLogicProxy.hasImplementation()) {
            BreedingLogicProxy.setInstance(initEvent.getBreedingLogic());
        }
        MinecraftForge.EVENT_BUS.register((Object)storageManager);
        MinecraftForge.EVENT_BUS.register((Object)StorageProxy.getSaveScheduler());
        MinecraftForge.EVENT_BUS.register((Object)StorageProxy.getSaveAdapter());
        event.enqueueWork(() -> {
            WoodType.m_61844_((WoodType)PixelmonWoodType.BLUE_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.GREEN_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.PINK_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.PURPLE_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.RED_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.YELLOW_BERRY_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.ULTRA_JUNGLE_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.ULTRA_ELM_WOOD);
            WoodType.m_61844_((WoodType)PixelmonWoodType.ULTRA_GINGKO_WOOD);
        });
    }

    @SubscribeEvent
    public static void postInit(FMLLoadCompleteEvent event) {
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> StorageProxy::clearAll);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        new PixelmonCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getCommandSelection());
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (PixelmonSpawning.coordinator == null) {
            PixelmonSpawning.startTrackingSpawner();
        }
        PixelmonDayCare.init();
        PackRepository resourcepacklist = event.getServer().m_129891_();
        resourcepacklist.m_10506_();
        List datapacks = resourcepacklist.m_10524_().stream().map(Pack::m_10446_).collect(Collectors.toList());
        LOGGER.info("Datapacks found: " + String.join((CharSequence)",", datapacks));
        if (Pixelmon.isDevEnvironment() || System.getenv("PIXELMON_DEBUG") != null) {
            DevTools.init();
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        PixelmonSpawning.coordinator.deactivate();
        PixelmonSpawning.coordinator = null;
        StorageProxy.getSaveScheduler().onServerStopping(event);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isClient() {
        return Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT;
    }

    public static boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    static {
        freeze = false;
        canSendOutPokemon = true;
    }
}

