/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.tcg.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.tcg.requirement.AbstractCardRequirement;
import com.pixelmonmod.tcg.api.card.Card;
import com.pixelmonmod.tcg.api.card.CardRarity;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;

public class RarityRequirement
extends AbstractCardRequirement<CardRarity> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"rarity"});
    private CardRarity rarity;

    public RarityRequirement() {
        super(KEYS);
    }

    public RarityRequirement(CardRarity rarity) {
        this();
        this.rarity = rarity;
    }

    @Override
    public ParseAttempt<Requirement<Card, ItemStack, CardRarity>> createInstance(CardRarity value) {
        return ParseAttempt.success(new RarityRequirement(value));
    }

    @Override
    public boolean isDataMatch(Card card) {
        return card.getBase().getRarity() == this.rarity;
    }

    @Override
    public void applyData(Card card) {
    }

    @Override
    public CardRarity getValue() {
        return this.rarity;
    }

    @Override
    public ParseAttempt<List<Requirement<Card, ItemStack, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("Cannot find key");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return ParseAttempt.error("Cannot find key");
        }
        return this.createInstance(CardRarity.valueOf(args[1].toUpperCase())).map(Collections::singletonList);
    }
}

