/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStringStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import java.util.Set;

public class StatueTextureRequirement
extends AbstractStringStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"statuetexture", "texturetype", "texture"});
    private static final String DEFAULT = EnumStatueTextureType.OriginalTexture.toString();

    public StatueTextureRequirement() {
        super(KEYS, DEFAULT);
    }

    public StatueTextureRequirement(String value) {
        super(KEYS, DEFAULT, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new StatueTextureRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
    }

    @Override
    public boolean isMinecraftMatch(StatueEntity entity) {
        return entity.getTextureType().toString().equalsIgnoreCase(this.value);
    }

    @Override
    public void applyMinecraft(StatueEntity entity) {
        for (EnumStatueTextureType enumStatueTextureType : EnumStatueTextureType.values()) {
            if (!enumStatueTextureType.toString().equalsIgnoreCase(this.value)) continue;
            entity.setTextureType(enumStatueTextureType);
            return;
        }
    }
}

