/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SpeciesRequirement
extends AbstractStatueRequirement<RegistryValue<Species>> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"species", "ndex"});
    private RegistryValue<Species> species;

    public SpeciesRequirement() {
        super(KEYS);
    }

    public SpeciesRequirement(RegistryValue<Species> species) {
        this();
        this.species = species;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String spec) {
        String[] args = spec.split(" ");
        if (args.length < 1) {
            return super.create(spec);
        }
        Optional<RegistryValue<Species>> species = PixelmonSpecies.get(args[0]);
        if (!species.isPresent()) {
            return super.create(spec);
        }
        return this.createInstance(species.get()).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("Cannot find key");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return ParseAttempt.error("Cannot find species");
        }
        RegistryValue<Species> species = PixelmonSpecies.fromName(args[1]);
        if (species == null) {
            return ParseAttempt.error("Invalid species");
        }
        return this.createInstance(species).map(Collections::singletonList);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, RegistryValue<Species>>> createInstance(RegistryValue<Species> value) {
        return ParseAttempt.success(new SpeciesRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getSpecies().is(this.species);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setSpecies(this.species, false);
    }

    @Override
    public RegistryValue<Species> getValue() {
        return this.species;
    }

    @Override
    public boolean fits(String spec) {
        String[] args = spec.split(" ");
        if (PixelmonSpecies.has(args[0])) {
            return true;
        }
        return super.fits(spec);
    }
}

