/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.StatueSpecification;
import com.pixelmonmod.api.statue.StatueSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Collections;
import java.util.List;

public class RandomSpeciesRequirement
implements Requirement<Pokemon, StatueEntity, StatueSpecification> {
    private static final List<String> KEYS = Lists.newArrayList((Object[])new String[]{"random", "randomspecies"});
    protected StatueSpecification spec;

    public RandomSpeciesRequirement() {
    }

    public RandomSpeciesRequirement(StatueSpecification spec) {
        this.spec = spec;
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, StatueSpecification>> createInstance(StatueSpecification value) {
        return ParseAttempt.success(new RandomSpeciesRequirement(value));
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public boolean shouldContinue() {
        return false;
    }

    @Override
    public List<String> getAliases() {
        return KEYS;
    }

    @Override
    public boolean fits(String spec) {
        for (String key : KEYS) {
            if (!spec.startsWith(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String spec) {
        for (String key : KEYS) {
            if (!spec.startsWith(key)) continue;
            if (spec.length() == key.length()) {
                return this.createInstance(null).map(Collections::singletonList);
            }
            String remainingSpec = spec.substring(key.length() + 1);
            if (remainingSpec.isEmpty()) {
                return this.createInstance(null).map(Collections::singletonList);
            }
            if (this.fits(remainingSpec)) {
                return ParseAttempt.error("You cannot have a random followed by a random");
            }
            ParseAttempt<StatueSpecification> parseAttempt = StatueSpecificationProxy.create(remainingSpec);
            if (!parseAttempt.wasSuccess()) {
                return parseAttempt.map(pokemonSpecification -> Collections.emptyList());
            }
            return this.createInstance(parseAttempt.get()).map(Collections::singletonList);
        }
        return ParseAttempt.error("Cannot find any data");
    }

    @Override
    public boolean isMinecraftMatch(StatueEntity entity) {
        return this.spec == null || this.spec.matches((Object)entity);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return this.spec == null || this.spec.matches(pixelmon);
    }

    @Override
    public void applyMinecraft(StatueEntity statue) {
        statue.getPokemon().setSpecies(PixelmonSpecies.getRandomSpecies(), false);
        if (this.spec != null) {
            this.spec.apply((Object)statue);
        }
        for (int counter = 0; this.spec != null && !this.spec.matches((Object)statue) && counter <= 250; ++counter) {
            statue.getPokemon().setSpecies(PixelmonSpecies.getRandomSpecies(), false);
            this.spec.apply((Object)statue);
        }
    }

    @Override
    public StatueSpecification getValue() {
        return this.spec;
    }

    @Override
    public void applyData(Pokemon pokemon) {
        pokemon.setSpecies(PixelmonSpecies.getRandomSpecies(), false);
        if (this.spec != null) {
            this.spec.apply(pokemon);
        }
        for (int counter = 0; this.spec != null && !this.spec.matches(pokemon) && counter <= 250; ++counter) {
            pokemon.setSpecies(PixelmonSpecies.getRandomSpecies(), false);
            this.spec.apply(pokemon);
        }
    }
}

