/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStringStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;

public class PaletteRequirement
extends AbstractStringStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"palette", "ispalette", "p", "ct", "customtexture"});
    private static final String DEFAULT_VALUE = "none";

    public PaletteRequirement() {
        super(KEYS, DEFAULT_VALUE);
    }

    public PaletteRequirement(String value) {
        super(KEYS, DEFAULT_VALUE, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new PaletteRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getPalette() != null && pixelmon.getPalette().getName().equalsIgnoreCase(this.value);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        GenderProperties genderProperties;
        PaletteProperties palette;
        Gender gender;
        Stats form = pixelmon.getForm();
        if (form == null) {
            form = pixelmon.getSpecies().getDefaultForm();
            pixelmon.setForm(form);
        }
        if ((gender = pixelmon.getGender()) == null || !form.isPossibleGender(gender)) {
            gender = form.getDefaultGender();
            pixelmon.setGender(gender);
        }
        if ((palette = (genderProperties = form.getGenderProperties(gender)).getPalette(this.value)) == null) {
            palette = genderProperties.getPalette(this.defaultValue);
        }
        pixelmon.setPalette(palette);
    }
}

