/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.StatueSpecification;
import com.pixelmonmod.api.statue.StatueSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class LogicalNOTRequirement
implements Requirement<Pokemon, StatueEntity, StatueSpecification> {
    private static final List<String> KEYS = Lists.newArrayList((Object[])new String[]{"!", "not"});
    private StatueSpecification spec;

    public LogicalNOTRequirement(StatueSpecification spec) {
        this.spec = spec;
    }

    public LogicalNOTRequirement() {
    }

    @Override
    public List<String> getAliases() {
        return KEYS;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean fits(String spec) {
        for (String s : spec.split(" ")) {
            if (!s.startsWith("!")) continue;
            return true;
        }
        for (String key : KEYS) {
            if (!spec.contains(key + ":")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String spec) {
        for (String subSpec : spec.split(" ")) {
            if (!subSpec.startsWith("!") && !subSpec.toLowerCase(Locale.ROOT).startsWith("not:")) continue;
            if (subSpec.equals("!") || subSpec.equalsIgnoreCase("not:")) {
                return ParseAttempt.error("The logical NOT must be followed by a valid spec");
            }
            ParseAttempt<StatueSpecification> parseAttempt = StatueSpecificationProxy.create(this.getSubSpec(subSpec));
            if (!parseAttempt.wasSuccess()) {
                return ParseAttempt.error("Invalid spec was provided to the logical NOT: " + parseAttempt.getError() + " (" + this.getSubSpec(subSpec) + ")");
            }
            return this.createInstance(parseAttempt.get()).map(Collections::singletonList);
        }
        return null;
    }

    protected String getSubSpec(String value) {
        if (value.startsWith("!")) {
            return value.substring(1);
        }
        return value.substring(4);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, StatueSpecification>> createInstance(StatueSpecification value) {
        return ParseAttempt.success(new LogicalNOTRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pokemon) {
        return !this.spec.matches(pokemon);
    }

    @Override
    public boolean isMinecraftMatch(StatueEntity StatueEntity2) {
        return !this.spec.matches((Object)StatueEntity2);
    }

    @Override
    public void applyData(Pokemon pokemon) {
    }

    @Override
    public void applyMinecraft(StatueEntity StatueEntity2) {
    }

    @Override
    public StatueSpecification getValue() {
        return this.spec;
    }
}

