/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractIntegerStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;

public class GrowthStageRequirement
extends AbstractIntegerStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"growthstage"});
    private static final int DEFAULT_VALUE = 0;

    public GrowthStageRequirement() {
        super(KEYS, 0);
    }

    public GrowthStageRequirement(int value) {
        super(KEYS, 0, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new GrowthStageRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.WOOLOO, PixelmonSpecies.MAREEP, PixelmonSpecies.DUBWOOL)) {
            return false;
        }
        ShearableStats stats = pixelmon.getExtraStats(ShearableStats.class).orElse(null);
        if (stats == null) {
            return false;
        }
        return stats.growthStage == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.WOOLOO, PixelmonSpecies.MAREEP, PixelmonSpecies.DUBWOOL)) {
            return;
        }
        ShearableStats stats = pixelmon.getExtraStats(ShearableStats.class).orElse(null);
        if (stats == null) {
            return;
        }
        stats.growthStage = (byte)this.value;
    }
}

