/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GrowthRequirement
extends AbstractStatueRequirement<EnumGrowth> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"growth", "gr"});
    private EnumGrowth growth;

    public GrowthRequirement() {
        super(KEYS);
    }

    public GrowthRequirement(EnumGrowth growth) {
        this();
        this.growth = growth;
    }

    @Override
    public ParseAttempt<List<Requirement<Pokemon, StatueEntity, ?>>> create(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return ParseAttempt.error("No key found");
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0) {
            return this.createInstance(EnumGrowth.Ordinary).map(Collections::singletonList);
        }
        EnumGrowth growth = this.parseGrowth(args[1]);
        if (growth == null) {
            return ParseAttempt.error("Invalid growth: " + args[1]);
        }
        return this.createInstance(growth).map(Collections::singletonList);
    }

    private EnumGrowth parseGrowth(String s) {
        EnumGrowth growth = EnumGrowth.getGrowthFromString(s);
        if (growth == null) {
            try {
                growth = EnumGrowth.getGrowthFromIndex(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return growth;
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, EnumGrowth>> createInstance(EnumGrowth value) {
        return ParseAttempt.success(new GrowthRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(pixelmon.getGrowth(), this.growth);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setGrowth(this.growth);
    }

    @Override
    public EnumGrowth getValue() {
        return this.growth;
    }
}

