/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractIntegerStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;

public class GenerationRequirement
extends AbstractIntegerStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"generation", "gen"});
    private static final int DEFAULT_VALUE = 1;

    public GenerationRequirement() {
        super(KEYS, 1);
    }

    public GenerationRequirement(int value) {
        super(KEYS, 1, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, Integer>> createInstance(Integer value) {
        return ParseAttempt.success(new GenerationRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getSpecies().getGeneration() == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setSpecies(PixelmonSpecies.getRandomFromGeneration(this.value).orElse(pixelmon.getSpecies()), true);
    }
}

