/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStringStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.egg.EggGroup;
import com.pixelmonmod.pixelmon.api.registries.EggGroupRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;

public class EggGroupRequirement
extends AbstractStringStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"egggroup", "egg_group"});

    public EggGroupRequirement() {
        super(KEYS, "water_one");
    }

    public EggGroupRequirement(String value) {
        super(KEYS, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new EggGroupRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        EggGroup eggGroup = EggGroupRegistry.getEggGroup(this.value).orElse(null);
        if (eggGroup == null) {
            return false;
        }
        return pixelmon.getForm().getEggGroups().contains(eggGroup);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
    }
}

