/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractBooleanStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CrownedRequirement
extends AbstractBooleanStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"cancrowned"});

    public CrownedRequirement() {
        super(KEYS);
    }

    public CrownedRequirement(boolean value) {
        super(KEYS, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, Boolean>> createInstance(Boolean value) {
        return ParseAttempt.success(new CrownedRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return pixelmon.getForm().isForm("hero") && (pixelmon.getSpecies().is(PixelmonSpecies.ZACIAN) && pixelmon.getHeldItemAsItemHeld() == PixelmonItems.rusted_sword || pixelmon.getSpecies().is(PixelmonSpecies.ZAMAZENTA) && pixelmon.getHeldItemAsItemHeld() == PixelmonItems.rusted_shield);
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.ZACIAN, PixelmonSpecies.ZAMAZENTA)) {
            pixelmon.setSpecies(RandomHelper.getRandomElementFromArray(PixelmonSpecies.ZACIAN, PixelmonSpecies.ZAMAZENTA), true);
        }
        if (pixelmon.getSpecies().is(PixelmonSpecies.ZACIAN)) {
            pixelmon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.rusted_sword));
        } else {
            pixelmon.setHeldItem(new ItemStack((ItemLike)PixelmonItems.rusted_shield));
        }
    }
}

