/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStringStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumBoundingBoxMode;
import java.util.Set;

public class BoundingBoxModeRequirement
extends AbstractStringStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"bbmode", "boundingboxmode"});

    public BoundingBoxModeRequirement() {
        super(KEYS, EnumBoundingBoxMode.Pushout.toString());
    }

    public BoundingBoxModeRequirement(String value) {
        super(KEYS, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new BoundingBoxModeRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
    }

    @Override
    public boolean isMinecraftMatch(StatueEntity entity) {
        return entity.getBoundingMode().toString().equalsIgnoreCase(this.value);
    }

    @Override
    public void applyMinecraft(StatueEntity entity) {
        for (EnumBoundingBoxMode enumBoundingBoxMode : EnumBoundingBoxMode.values()) {
            if (!enumBoundingBoxMode.toString().equalsIgnoreCase(this.value)) continue;
            entity.setBoundingMode(enumBoundingBoxMode);
        }
    }
}

