/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.statue.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.parsing.ParseAttempt;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.api.statue.requirement.AbstractStringStatueRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import java.util.Set;

public class AnimationTypeRequirement
extends AbstractStringStatueRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"animationtype"});
    private static final String DEFAULT = AnimationType.IDLE.toString();

    public AnimationTypeRequirement() {
        super(KEYS, DEFAULT);
    }

    public AnimationTypeRequirement(String value) {
        super(KEYS, DEFAULT, value);
    }

    @Override
    public ParseAttempt<Requirement<Pokemon, StatueEntity, String>> createInstance(String value) {
        return ParseAttempt.success(new AnimationTypeRequirement(value));
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return false;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
    }

    @Override
    public boolean isMinecraftMatch(StatueEntity entity) {
        return entity.getAnimation().toString().equalsIgnoreCase(this.value);
    }

    @Override
    public void applyMinecraft(StatueEntity entity) {
        for (AnimationType enumStatueAnimationType : AnimationType.values()) {
            if (!enumStatueAnimationType.toString().equalsIgnoreCase(this.value)) continue;
            entity.setAnimation(enumStatueAnimationType);
            return;
        }
    }
}

